/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.QueryHints;
import org.springframework.data.jpa.repository.support.Querydsl;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QSort;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.support.PageableExecutionUtils;
import org.springframework.util.Assert;

@Deprecated
public class QuerydslJpaRepository<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements QuerydslPredicateExecutor<T> {
    private final EntityPath<T> path;
    private final PathBuilder<T> builder;
    private final Querydsl querydsl;
    private final EntityManager entityManager;

    public QuerydslJpaRepository(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager) {
        this(entityInformation, entityManager, SimpleEntityPathResolver.INSTANCE);
    }

    public QuerydslJpaRepository(JpaEntityInformation<T, ID> entityInformation, EntityManager entityManager, EntityPathResolver resolver) {
        super(entityInformation, entityManager);
        this.path = resolver.createPath(entityInformation.getJavaType());
        this.builder = new PathBuilder(this.path.getType(), this.path.getMetadata());
        this.querydsl = new Querydsl(entityManager, this.builder);
        this.entityManager = entityManager;
    }

    @Override
    public Optional<T> findOne(Predicate predicate) {
        try {
            return Optional.ofNullable(this.createQuery(predicate).select(this.path).fetchOne());
        }
        catch (NonUniqueResultException ex) {
            throw new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, ex);
        }
    }

    @Override
    public List<T> findAll(Predicate predicate) {
        return this.createQuery(predicate).select(this.path).fetch();
    }

    @Override
    public List<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        return this.executeSorted(this.createQuery(predicate).select(this.path), orders);
    }

    @Override
    public List<T> findAll(Predicate predicate, Sort sort) {
        Assert.notNull((Object)sort, "Sort must not be null!");
        return this.executeSorted(this.createQuery(predicate).select(this.path), sort);
    }

    @Override
    public List<T> findAll(OrderSpecifier<?> ... orders) {
        Assert.notNull(orders, "Order specifiers must not be null!");
        return this.executeSorted(this.createQuery(new Predicate[0]).select(this.path), orders);
    }

    @Override
    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        Assert.notNull((Object)pageable, "Pageable must not be null!");
        JPQLQuery<?> countQuery = this.createCountQuery(predicate);
        JPQLQuery query2 = this.querydsl.applyPagination(pageable, this.createQuery(predicate).select(this.path));
        return PageableExecutionUtils.getPage(query2.fetch(), pageable, () -> countQuery.fetchCount());
    }

    @Override
    public long count(Predicate predicate) {
        return this.createQuery(predicate).fetchCount();
    }

    @Override
    public boolean exists(Predicate predicate) {
        return this.createQuery(predicate).fetchCount() > 0L;
    }

    protected JPQLQuery<?> createQuery(Predicate ... predicate) {
        AbstractJPAQuery query2 = this.doCreateQuery(this.getQueryHints().withFetchGraphs(this.entityManager), predicate);
        CrudMethodMetadata metadata = this.getRepositoryMethodMetadata();
        if (metadata == null) {
            return query2;
        }
        LockModeType type = metadata.getLockModeType();
        return type == null ? query2 : query2.setLockMode(type);
    }

    protected JPQLQuery<?> createCountQuery(Predicate ... predicate) {
        return this.doCreateQuery(this.getQueryHints(), predicate);
    }

    private AbstractJPAQuery<?, ?> doCreateQuery(QueryHints hints, Predicate ... predicate) {
        AbstractJPAQuery query2 = this.querydsl.createQuery(this.path);
        if (predicate != null) {
            query2 = (AbstractJPAQuery)query2.where(predicate);
        }
        hints.forEach((arg_0, arg_1) -> ((AbstractJPAQuery)query2).setHint(arg_0, arg_1));
        return query2;
    }

    private List<T> executeSorted(JPQLQuery<T> query2, OrderSpecifier<?> ... orders) {
        return this.executeSorted(query2, new QSort(orders));
    }

    private List<T> executeSorted(JPQLQuery<T> query2, Sort sort) {
        return this.querydsl.applySorting(sort, query2).fetch();
    }
}

