/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.TypeConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DataClassRowMapper<T>
extends BeanPropertyRowMapper<T> {
    @Nullable
    private Constructor<T> mappedConstructor;
    @Nullable
    private String[] constructorParameterNames;
    @Nullable
    private Class<?>[] constructorParameterTypes;

    public DataClassRowMapper() {
    }

    public DataClassRowMapper(Class<T> mappedClass) {
        super(mappedClass);
    }

    @Override
    protected void initialize(Class<T> mappedClass) {
        super.initialize(mappedClass);
        this.mappedConstructor = BeanUtils.getResolvableConstructor(mappedClass);
        if (this.mappedConstructor.getParameterCount() > 0) {
            this.constructorParameterNames = BeanUtils.getParameterNames(this.mappedConstructor);
            this.constructorParameterTypes = this.mappedConstructor.getParameterTypes();
        }
    }

    @Override
    protected T constructMappedInstance(ResultSet rs, TypeConverter tc) throws SQLException {
        Object[] args;
        Assert.state(this.mappedConstructor != null, "Mapped constructor was not initialized");
        if (this.constructorParameterNames != null && this.constructorParameterTypes != null) {
            args = new Object[this.constructorParameterNames.length];
            for (int i = 0; i < args.length; ++i) {
                String name = this.underscoreName(this.constructorParameterNames[i]);
                Class<?> type = this.constructorParameterTypes[i];
                args[i] = tc.convertIfNecessary(this.getColumnValue(rs, rs.findColumn(name), type), type);
            }
        } else {
            args = new Object[]{};
        }
        return BeanUtils.instantiateClass(this.mappedConstructor, args);
    }

    public static <T> DataClassRowMapper<T> newInstance(Class<T> mappedClass) {
        return new DataClassRowMapper<T>(mappedClass);
    }

    public static <T> DataClassRowMapper<T> newInstance(Class<T> mappedClass, @Nullable ConversionService conversionService) {
        DataClassRowMapper<T> rowMapper = DataClassRowMapper.newInstance(mappedClass);
        rowMapper.setConversionService(conversionService);
        return rowMapper;
    }
}

