/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.GameTippDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.User;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="gameTippDao")
public class GameTippDaoHibernate
extends AbstractCommonDao<GameTipp>
implements GameTippDao {
    private static final String QUERY_GAMETIPP_BY_MATCH = "from     GameTipp gametipp inner join fetch     gametipp.user inner join fetch     gametipp.game where     gametipp.game.id = :gameId";
    private static final String QUERY_GAMETIPP_BY_SEASON_ROUND_AND_USER = AbstractCommonDao.loadQuery("hql_gametipp_season_round_user.sql");

    public GameTippDaoHibernate() {
        super(GameTipp.class);
    }

    @Override
    public List<GameTipp> findByMatch(Game match) {
        List tipps = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMETIPP_BY_MATCH).setParameter("gameId", (Object)match.getId()).list();
        return tipps;
    }

    @Override
    public List<GameTipp> findTippsByRoundAndUser(GameList round, User user) {
        List objects = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMETIPP_BY_SEASON_ROUND_AND_USER).setParameter("roundId", (Object)round.getId()).setParameter("userId", (Object)user.getId()).list();
        return objects;
    }

    @Override
    public List<GameTipp> findTippsByRoundAndUser(long seasonId, long roundId, String nickname) {
        return null;
    }
}

