/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage.comparator;

import de.awtools.basic.LoggerFactory;
import de.winkler.betoffice.storage.UserResult;
import java.util.Comparator;
import org.slf4j.Logger;

public final class UserPointsComparator
implements Comparator<UserResult> {
    private final Logger log = LoggerFactory.make();

    @Override
    public int compare(UserResult u1, UserResult u2) {
        int retcode = 0;
        if (u1.getPoints() > u2.getPoints()) {
            retcode = -1;
        } else if (u1.getPoints() < u2.getPoints()) {
            retcode = 1;
        } else if (u1.getPoints() == u2.getPoints()) {
            if (u1.getUserWin() > u2.getUserWin()) {
                retcode = -1;
            } else if (u1.getUserWin() < u2.getUserWin()) {
                retcode = 1;
            } else if (u1.getUserWin() == u2.getUserWin()) {
                retcode = u1.getUser().getNickName().toLowerCase().compareTo(u2.getUser().getNickName().toLowerCase());
            } else {
                throw new IllegalStateException();
            }
        }
        if (this.log.isDebugEnabled()) {
            if (retcode < 0) {
                this.log.debug(u1.getUser().getNickName() + " > " + u2.getUser().getNickName());
            } else if (retcode > 0) {
                this.log.debug(u2.getUser().getNickName() + " > " + u1.getUser().getNickName());
            } else {
                this.log.debug(u1.getUser().getNickName() + " == " + u2.getUser().getNickName());
            }
        }
        return retcode;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }
}

