/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.RoundDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Season;
import java.math.BigInteger;
import java.util.List;
import org.hibernate.SQLQuery;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

@Repository(value="roundDao")
public class RoundDaoHibernate
extends AbstractCommonDao<GameList>
implements RoundDao {
    private static final String QUERY_GAMELIST_BY_SEASON = "from GameList as gamelist where gamelist.season.id = :seasonId order by gamelist.index";
    private static final String QUERY_GAMELIST_BY_SEASON_AND_INDEX = "from GameList as gamelist where gamelist.season.id = :seasonId and gamelist.index = :gameListIndex";
    private static final String QUERY_ALL_ROUND_OBJECTS = "select round from GameList as round left join fetch round.gameList game left join fetch game.tippList tipp left join fetch tipp.user u left join fetch game.homeTeam left join fetch game.guestTeam left join fetch game.group where round.season.id = :seasonId and round.index = :gameListIndex";

    public RoundDaoHibernate() {
        super(GameList.class);
    }

    @Override
    public List<GameList> findRounds(Season season) {
        List objects = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMELIST_BY_SEASON).setParameter("seasonId", (Object)season.getId()).list();
        return objects;
    }

    @Override
    public GameList findRound(Season season, int index) {
        List rounds = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMELIST_BY_SEASON_AND_INDEX).setParameter("seasonId", (Object)season.getId()).setParameter("gameListIndex", (Object)index).list();
        GameList result = null;
        if (!rounds.isEmpty()) {
            result = (GameList)rounds.get(0);
        }
        return result;
    }

    @Override
    public GameList findAllRoundObjects(Season season, int index) {
        List rounds = this.getSessionFactory().getCurrentSession().createQuery(QUERY_ALL_ROUND_OBJECTS).setParameter("seasonId", (Object)season.getId()).setParameter("gameListIndex", (Object)index).list();
        return (GameList)rounds.get(0);
    }

    @Override
    public Long findNextTippRound(Season season, DateTime date) {
        String sql = "select min(t.bo_datetime) datetime, t.id next_round_id from (select * from bo_gamelist where bo_season_ref = :season_id and bo_datetime >= :date) as t";
        SQLQuery query = this.getSessionFactory().getCurrentSession().createSQLQuery(sql);
        query.setParameter("season_id", (Object)season.getId());
        query.setDate("date", date.toDate());
        query.addScalar("datetime");
        query.addScalar("next_round_id");
        Object[] uniqueResult = (Object[])query.uniqueResult();
        Long roundId = null;
        if (uniqueResult != null && uniqueResult[1] != null) {
            roundId = ((BigInteger)uniqueResult[1]).longValue();
        }
        return roundId;
    }
}

