/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.Team;
import org.apache.commons.lang.Validate;

public class TeamResult
extends AbstractStorageObject
implements Comparable<TeamResult> {
    private static final long serialVersionUID = -6690928605407554417L;
    private Group group;
    private Team team;
    private int posGoals;
    private int negGoals;
    private int win;
    private int lost;
    private int remis;
    private int tablePosition;

    public TeamResult(Group aGroup, Team aTeam) {
        this.group = aGroup;
        this.team = aTeam;
    }

    public boolean isValid() {
        return this.group != null && this.team != null;
    }

    public Group getGroup() {
        return this.group;
    }

    public Team getTeam() {
        return this.team;
    }

    public int getPosGoals() {
        return this.posGoals;
    }

    public void setPosGoals(int posGoals) {
        this.posGoals = posGoals;
    }

    public int getNegGoals() {
        return this.negGoals;
    }

    public void setNegGoals(int negGoals) {
        this.negGoals = negGoals;
    }

    private int getGoalDiff() {
        return this.posGoals - this.negGoals;
    }

    public int getWin() {
        return this.win;
    }

    public void setWin(int win) {
        this.win = win;
    }

    public int getLost() {
        return this.lost;
    }

    public void setLost(int lost) {
        this.lost = lost;
    }

    public int getRemis() {
        return this.remis;
    }

    public void setRemis(int remis) {
        this.remis = remis;
    }

    public int getPoints() {
        return this.getWin() * 3 + this.getRemis() * 1;
    }

    public int getGames() {
        return this.getWin() + this.getRemis() + this.getLost();
    }

    public void setTabPos(int _tablePosition) {
        this.tablePosition = _tablePosition;
    }

    public int getTabPos() {
        return this.tablePosition;
    }

    private String getGoalsToString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getPosGoals());
        buf.append(':');
        buf.append(this.getNegGoals());
        return buf.toString();
    }

    public static int isBetterAs(TeamResult team1, TeamResult team2) {
        Validate.notNull((Object)team1, (String)"team1 ist null");
        Validate.notNull((Object)team2, (String)"team2 ist null");
        if (team1.getPoints() > team2.getPoints()) {
            return 1;
        }
        if (team1.getPoints() < team2.getPoints()) {
            return -1;
        }
        if (team1.getGoalDiff() > team2.getGoalDiff()) {
            return 1;
        }
        if (team1.getGoalDiff() < team2.getGoalDiff()) {
            return -1;
        }
        if (team1.getPosGoals() > team2.getPosGoals()) {
            return 1;
        }
        if (team1.getPosGoals() < team2.getPosGoals()) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareTo(TeamResult obj) {
        return TeamResult.isBetterAs(obj, this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.getTeam() == null) {
            buf.append("<null>");
        } else {
            buf.append(this.getTeam().getName());
        }
        buf.append(" Group: ");
        buf.append(this.getGroup().getGroupType().getName());
        buf.append(" Goals:");
        buf.append(this.getGoalsToString());
        buf.append(" Points:");
        buf.append(this.getPoints());
        return buf.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof TeamResult)) {
            return false;
        }
        TeamResult result = (TeamResult)object;
        return result.getTeam().equals(this.getTeam()) && result.getGroup().equals(this.getGroup()) && result.getPosGoals() == this.getPosGoals() && result.getNegGoals() == this.getNegGoals() && result.getWin() == this.getWin() && result.getRemis() == this.getRemis() && result.getLost() == this.getLost();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getTeam().hashCode();
        result = 37 * result + this.getGroup().hashCode();
        result = 37 * result + this.posGoals;
        result = 37 * result + this.negGoals;
        result = 37 * result + this.win;
        result = 37 * result + this.lost;
        result = 37 * result + this.remis;
        return result;
    }
}

