/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.mail;

import de.winkler.betoffice.mail.TippMail;
import de.winkler.betoffice.mail.TippMailParameter;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class TippToInfoMailConverter {
    public TippMail createTippMail(TippMailParameter param) {
        int anzahl = param.getHomeGoals().length;
        StringBuilder body = new StringBuilder();
        body.append("Guten Tag!\n");
        body.append("Hier ist der Tipp von '").append(param.getNickname()).append("' f\u00fcr den ");
        body.append(param.getRoundNr()).append(". Spieltag.\n");
        String timeStamp = DateTime.now().toString("dd.MM.yyyy HH:mm", Locale.GERMANY);
        body.append("Der Tipp wurde am ").append(timeStamp);
        body.append(" versendet!\n");
        body.append("\n");
        if (anzahl == 0) {
            body.append("\n");
        } else {
            for (int index = 0; index < anzahl; ++index) {
                body.append(StringUtils.rightPad((String)param.getHomeTeams()[index], (int)20));
                body.append(" - ");
                body.append(StringUtils.rightPad((String)param.getGuestTeams()[index], (int)20));
                body.append(" Tipp: ");
                body.append(StringUtils.rightPad((String)Integer.toString(param.getHomeGoals()[index]), (int)2));
                body.append(":");
                body.append(StringUtils.rightPad((String)Integer.toString(param.getGuestGoals()[index]), (int)2));
                body.append("\n");
            }
        }
        body.append("\n");
        body.append("Diese EMail wurde von 'Winklers virtuellen Sportwetten'");
        body.append("\n");
        body.append("automatisch generiert. Bitte nicht auf diese EMail antworten!");
        body.append("\n");
        body.append("F\u00fcr weitere Infos siehe unter http://www.tippdiekistebier.de");
        body.append("\n");
        return new TippMail(this.createSubject(param), body.toString());
    }

    private String createSubject(TippMailParameter param) {
        String subject = "Tipp-Abgabe Runde #" + param.getRoundNr() + " vom " + DateTime.now().toString("dd.MM.yyyy HH:mm", Locale.GERMANY);
        return subject;
    }
}

