/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class Group
extends AbstractStorageObject {
    private static final long serialVersionUID = 2621079132943084772L;
    private Long id;
    public static final String PROPERTY_SEASON = "season";
    private Season season;
    public static final String PROPERTY_TEAMS = "teams";
    private Set<Team> teams = new HashSet<Team>();
    public static final String PROPERTY_GROUPTYPE = "groupType";
    private GroupType groupType;

    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public Season getSeason() {
        return this.season;
    }

    protected void setSeason(Season value) {
        Validate.notNull((Object)value);
        this.season = value;
    }

    public Set<Team> getTeams() {
        return this.teams;
    }

    protected void setTeams(Set<Team> value) {
        this.teams = value;
    }

    public void addTeam(Team value) {
        Validate.notNull((Object)value);
        this.teams.add(value);
        value.addGroup(this);
    }

    public void removeTeam(Team value) {
        Validate.notNull((Object)value);
        this.teams.remove(value);
        value.removeGroup(this);
    }

    public boolean isGroupMember(Team team) {
        return this.teams.contains(team);
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(GroupType value) {
        this.groupType = value;
    }

    public boolean isValid() {
        if (this.getGroupType() == null) {
            return false;
        }
        return this.getSeason() != null;
    }

    public String toString() {
        return this.getGroupType().getName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Group)) {
            return false;
        }
        Group group = (Group)object;
        return group.getSeason().equals(this.getSeason()) && group.getGroupType().equals(this.getGroupType());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getGroupType().hashCode();
        result = 37 * result + this.getSeason().hashCode();
        return result;
    }
}

