/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.tippengine;

import de.awtools.basic.NumberUtils;
import de.winkler.betoffice.storage.UserResult;
import org.apache.commons.lang.Validate;

public class EvaluationUtil {
    private UserResult result;

    public EvaluationUtil(UserResult value) {
        Validate.notNull((Object)value, (String)"value ist 'null'.");
        this.result = value;
    }

    public String format(double _value) {
        NumberUtils numberUtils = new NumberUtils();
        return numberUtils.formatDouble(_value);
    }

    public double getTicketPercent() {
        if (this.result.getTippedGames() == 0) {
            return 0.0;
        }
        return (double)this.result.getTicket() / (double)this.result.getTippedGames() * 100.0;
    }

    public double getTotoPercent() {
        if (this.result.getTippedGames() == 0) {
            return 0.0;
        }
        return (double)this.result.getUserTotoWin() / (double)this.result.getTippedGames() * 100.0;
    }

    public double getWinPercent() {
        if (this.result.getTippedGames() == 0) {
            return 0.0;
        }
        return (double)this.result.getUserWin() / (double)this.result.getTippedGames() * 100.0;
    }
}

