/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.TeamDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.enums.TeamType;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="teamDao")
public class TeamDaoHibernate
extends AbstractCommonDao<Team>
implements TeamDao {
    private static final String QUERY_TEAMS_BY_SEASON_AND_GROUPTYPE = AbstractCommonDao.loadQuery("query_teams_by_season_and_grouptype.sql");
    public static final String QUERY_TEAM_BY_NAME = "from Team as team where team.name = :teamName";
    public static final String QUERY_TEAM_BY_TYPE = "from Team as team where team.teamType = :teamType order by team.name";
    public static final String QUERY_TEAM_BY_OPENLIGAID = "from Team as team where team.openligaid = :openligaid";

    public TeamDaoHibernate() {
        super(Team.class);
    }

    @Override
    public List<Team> findAll() {
        return this.getSessionFactory().getCurrentSession().createQuery("from Team as team order by team.name").list();
    }

    @Override
    public List<Team> findTeams(TeamType teamType) {
        return this.getSessionFactory().getCurrentSession().createQuery(QUERY_TEAM_BY_TYPE).setParameter("teamType", (Object)teamType).list();
    }

    @Override
    public Team findByName(String name) {
        List teams = this.getSessionFactory().getCurrentSession().createQuery(QUERY_TEAM_BY_NAME).setParameter("teamName", (Object)name).list();
        return (Team)this.first(teams);
    }

    @Override
    public List<Team> findTeamsBySeasonAndGroup(Season season, GroupType groupType) {
        List teams = this.getSessionFactory().getCurrentSession().createSQLQuery(QUERY_TEAMS_BY_SEASON_AND_GROUPTYPE).addEntity("team", Team.class).setParameter("season_id", (Object)season.getId()).setParameter("grouptype_id", (Object)groupType.getId()).list();
        return teams;
    }

    @Override
    public Team findByOpenligaid(long openligaid) {
        List teams = this.getSessionFactory().getCurrentSession().createQuery(QUERY_TEAM_BY_OPENLIGAID).setParameter("openligaid", (Object)openligaid).list();
        return (Team)this.first(teams);
    }
}

