/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.mail;

import de.awtools.basic.LoggerFactory;
import de.winkler.betoffice.mail.BetofficeMailer;
import de.winkler.betoffice.mail.TippMail;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.joda.time.DateTime;
import org.slf4j.Logger;

public class DefaultBetofficeMailer
implements BetofficeMailer {
    private final Logger log = LoggerFactory.make();
    private static final String HOST = "localhost";
    private static final String FROM = "betoffice@tippdiekistebier.de";
    private final Properties properties = System.getProperties();

    public DefaultBetofficeMailer() {
        this.properties.setProperty("mail.smtp.host", HOST);
    }

    @Override
    public void sendMail(String recipient, TippMail tippMail) throws MessagingException {
        Session session = Session.getDefaultInstance((Properties)this.properties);
        MimeMessage message = new MimeMessage(session);
        message.setHeader("MIME-Version", "1.0");
        message.setHeader("Content-type", "text/plain; charset=utf-8");
        message.setHeader("From", FROM);
        message.setFrom((Address)new InternetAddress(FROM));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
        message.setSubject(tippMail.getSubject());
        message.setText(tippMail.getContent(), "utf-8");
        message.setSentDate(DateTime.now().toDate());
        this.log.info("Sending an email to ->{}<- with subject ->{}<- and content ->{}<-", new Object[]{recipient, tippMail.getSubject(), tippMail.getContent()});
        Transport.send((Message)message);
    }
}

