/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.mail;

import de.winkler.betoffice.mail.TippMail;
import de.winkler.betoffice.mail.TippMailParameter;
import java.util.Locale;
import org.joda.time.DateTime;

public class TippToXmlConverter {
    public TippMail createTippMail(TippMailParameter param) {
        int index;
        int anzahl = param.getHomeGoals().length;
        StringBuilder body = new StringBuilder();
        body.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        body.append("<FORM>\n");
        body.append("<USE>Tipp-Abgabe Winkler Sportwetten</USE>\n");
        body.append("  <FORMINFO>").append(param.getHttpHost()).append("</FORMINFO>\n");
        body.append("  <USERIP>").append(param.getUserIp()).append("</USERIP>\n");
        body.append("  <BROWSER>").append(param.getHttpUserAgent()).append("</BROWSER>\n");
        String timeStamp = DateTime.now().toString("dd.MM.yyyy HH:mm", Locale.GERMANY);
        body.append("  <DATUM>").append(timeStamp).append("</DATUM>\n");
        body.append("  <TIME>").append(timeStamp).append("</TIME>\n");
        body.append("  <NICKNAME>").append(param.getNickname()).append("</NICKNAME>\n");
        body.append("  <CHAMPIONSHIP>").append(param.getChampionshipId()).append("</CHAMPIONSHIP>\n");
        body.append("  <ROUND>").append(param.getRoundNr()).append("</ROUND>\n");
        body.append("  <PWDA>").append(param.getPassword()).append("</PWDA>\n");
        body.append("  <HOMEGOALS>");
        if (anzahl == 0) {
            body.append("");
        } else {
            for (index = 0; index < anzahl; ++index) {
                body.append(param.getHomeGoals()[index]);
                if (index >= anzahl - 1) continue;
                body.append(",");
            }
        }
        body.append("</HOMEGOALS>\n");
        body.append("  <GUESTGOALS>");
        if (anzahl == 0) {
            body.append("");
        } else {
            for (index = 0; index < anzahl; ++index) {
                body.append(param.getGuestGoals()[index]);
                if (index >= anzahl - 1) continue;
                body.append(",");
            }
        }
        body.append("</GUESTGOALS>\n");
        body.append("</FORM>\n");
        return new TippMail(this.createSubject(param), body.toString());
    }

    private String createSubject(TippMailParameter param) {
        String subject = "Tipp-Abgabe Runde #" + param.getRoundNr() + " vom " + DateTime.now().toString("dd.MM.yyyy HH:mm", Locale.GERMANY);
        return subject;
    }
}

