/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.Goal;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Player;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.TeamResult;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResult;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;

public interface SeasonManagerService {
    public List<UserResult> calculateUserRanking(Season var1);

    public List<UserResult> calculateUserRanking(GameList var1);

    public List<UserResult> calculateUserRanking(Season var1, int var2, int var3);

    public List<TeamResult> calculateTeamRanking(Season var1, Group var2);

    public List<TeamResult> calculateTeamRanking(Season var1, Group var2, int var3, int var4);

    public List<User> findActivatedUsers(Season var1);

    public List<Season> findAllSeasons();

    public List<Goal> findAllGoals();

    public List<Team> findTeamsByGroup(Group var1);

    public List<Team> findTeamsByGroupType(Season var1, GroupType var2);

    public Season findSeasonByName(String var1, String var2);

    public Season findSeasonById(long var1);

    public GameList findRound(Season var1, int var2);

    public GameList findRoundById(long var1);

    public List<GameList> findRounds(Season var1);

    public Season findRoundGroupTeamUserRelations(Season var1);

    public List<GameTipp> findTippsByMatch(Game var1);

    public List<GameTipp> findTippsByRoundAndUser(GameList var1, User var2);

    public Season findRoundGroupTeamUserTippRelations(Season var1);

    public List<Group> findGroups(Season var1);

    public List<GroupType> findGroupTypesBySeason(Season var1);

    public List<Game> findMatches(Team var1, Team var2);

    public Game findMatch(GameList var1, Team var2, Team var3);

    public List<Game> findMatches(Team var1, Team var2, boolean var3);

    public Player findGoalsOfPlayer(long var1);

    public void createSeason(Season var1);

    public void deleteSeason(Season var1);

    public void updateSeason(Season var1);

    public void addUsers(Season var1, Collection<User> var2);

    public void removeUsers(Season var1, Collection<User> var2);

    public Group addGroupType(Season var1, GroupType var2);

    public void addGroupType(Season var1, Collection<GroupType> var2);

    public void removeGroupType(Season var1, GroupType var2);

    public void removeGroupType(Season var1, Collection<GroupType> var2);

    public void addTeam(Season var1, GroupType var2, Team var3);

    public void addTeams(Season var1, GroupType var2, Collection<Team> var3);

    public void removeTeam(Season var1, GroupType var2, Team var3);

    public void removeTeams(Season var1, GroupType var2, Collection<Team> var3);

    public GameList addRound(Season var1, DateTime var2, GroupType var3);

    public void removeRound(Season var1, GameList var2);

    public Game addMatch(GameList var1, DateTime var2, Group var3, Team var4, Team var5);

    public Game addMatch(GameList var1, DateTime var2, Group var3, Team var4, Team var5, int var6, int var7);

    public Game addMatch(Season var1, int var2, DateTime var3, GroupType var4, Team var5, Team var6);

    public Game addMatch(Season var1, int var2, DateTime var3, GroupType var4, Team var5, Team var6, int var7, int var8);

    public void updateMatch(Game var1);

    public void updateMatch(Collection<Game> var1);

    public void removeMatch(Game var1);

    public void addGoal(Game var1, Goal var2);
}

