/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.awtools.basic.LoggerFactory;
import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.User;
import org.slf4j.Logger;

public class UserResult
extends AbstractStorageObject {
    private static final long serialVersionUID = 3018999724329773561L;
    public static Logger log = LoggerFactory.make();
    public static long nEqualValue = 13L;
    public static long nTotoValue = 10L;
    public static long nZeroValue = 0L;
    public static long nDivisor = 10L;
    private final User user;
    private final Season season;
    private int totoWin = 0;
    private int win = 0;
    private int ticket = 0;
    private int tabPos = 0;

    public UserResult(User _user, Season _season) {
        this.user = _user;
        this.season = _season;
    }

    public boolean isValid() {
        if (this.user == null) {
            return false;
        }
        return this.season != null;
    }

    public void setUserWin(int _n) {
        this.win = _n;
    }

    public void setUserTotoWin(int _n) {
        this.totoWin = _n;
    }

    public void setTicket(int _n) {
        this.ticket = _n;
    }

    public void setTabPos(int _n) {
        this.tabPos = _n;
    }

    public void setReset() {
        this.totoWin = 0;
        this.win = 0;
        this.ticket = 0;
        this.tabPos = 0;
    }

    public User getUser() {
        return this.user;
    }

    public Season getSeason() {
        return this.season;
    }

    public int getUserWin() {
        return this.win;
    }

    public int getUserTotoWin() {
        return this.totoWin;
    }

    public int getTicket() {
        return this.ticket;
    }

    public long getPoints() {
        return nEqualValue * (long)this.win + nTotoValue * (long)this.totoWin;
    }

    public double getBeautyPoints() {
        return (double)this.getPoints() / (double)nDivisor;
    }

    public int getTippedGames() {
        return this.win + this.totoWin + this.ticket;
    }

    public int getTabPos() {
        return this.tabPos;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[class=UserResult; ");
        buf.append(", Season: ").append(this.getSeason().toString());
        buf.append(", User: ").append(this.user);
        buf.append(", #10 Pts: ").append(this.getUserTotoWin());
        buf.append(", #13 Pts: ").append(this.getUserWin());
        buf.append(", #Tickets: ").append(this.getTicket());
        buf.append(", SUM(points): ").append(this.getPoints());
        buf.append(", #Tipps: ").append(this.getTippedGames());
        buf.append(", Tabpos: ").append(this.getTabPos());
        buf.append("]");
        return buf.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return user.getNickName().equals(this.getUser().getNickName());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getUser().getNickName().hashCode();
        return result;
    }
}

