/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.SeasonDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.TeamResult;
import de.winkler.betoffice.storage.comparator.TeamPointsComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.SQLQuery;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.stereotype.Repository;

@Repository(value="seasonDao")
public class SeasonDaoHibernate
extends AbstractCommonDao<Season>
implements SeasonDao {
    private static final String QUERY_SEASON_BY_NAME_AND_YEAR = "from " + Season.class.getName() + " as season " + "where season.name = :name and season.year = :year";
    private static final String QUERY_ALL_SEASON_OBJECTS = "from Season season left join fetch season.gameList round left join fetch season.groups g left join fetch g.groupType gt left join fetch season.userSeason us left join fetch us.user u where season.id = :seasonId order by gt.name, round.index";
    private static final String QUERY_ALL_SEASON_WITH_TIPP_OBJECTS = "from Season season left join fetch season.gameList round left join fetch round.gameList games left join fetch games.tippList left join fetch season.groups g left join fetch g.groupType gt left join fetch season.userSeason us left join fetch us.user u where season.id = :seasonId order by gt.name, round.index";
    private static final String QUERY_TEAM_SEASON_GOALS = AbstractCommonDao.loadQuery("query_teamresult_season_goals.sql");
    private static final String QUERY_TEAM_SEASON_POINTS = AbstractCommonDao.loadQuery("query_teamresult_season_points.sql");
    private static final String QUERY_TEAM_SEASON_RANGE_GOALS = AbstractCommonDao.loadQuery("query_teamresult_season_range_goals.sql");
    private static final String QUERY_TEAM_SEASON_RANGE_POINTS = AbstractCommonDao.loadQuery("query_teamresult_season_range_points.sql");

    public SeasonDaoHibernate() {
        super(Season.class);
    }

    @Override
    public List<Season> findAll() {
        List objects = this.getSessionFactory().getCurrentSession().createQuery("from Season order by bo_year").list();
        return objects;
    }

    @Override
    public Season findByName(String name, String year) {
        List seasons = this.getSessionFactory().getCurrentSession().createQuery(QUERY_SEASON_BY_NAME_AND_YEAR).setParameter("name", (Object)name).setParameter("year", (Object)year).list();
        return (Season)this.first(seasons);
    }

    @Override
    public Season findRoundGroupTeamUser(Season season) {
        List seasons = this.getSessionFactory().getCurrentSession().createQuery(QUERY_ALL_SEASON_OBJECTS).setParameter("seasonId", (Object)season.getId()).list();
        return (Season)this.first(seasons);
    }

    @Override
    public Season findRoundGroupTeamUserTipp(Season season) {
        List seasons = this.getSessionFactory().getCurrentSession().createQuery(QUERY_ALL_SEASON_WITH_TIPP_OBJECTS).setParameter("seasonId", (Object)season.getId()).list();
        return (Season)this.first(seasons);
    }

    @Override
    public List<TeamResult> calculateTeamRanking(Season season, Group group) {
        HashMap<Team, TeamResult> resultMap = new HashMap<Team, TeamResult>();
        SQLQuery queryTeamGoals = this.getSessionFactory().getCurrentSession().createSQLQuery(QUERY_TEAM_SEASON_GOALS).addEntity("team", Team.class).addScalar("diff", (Type)StandardBasicTypes.LONG).addScalar("pos_goals", (Type)StandardBasicTypes.LONG).addScalar("neg_goals", (Type)StandardBasicTypes.LONG);
        queryTeamGoals.setParameter("season_id", (Object)season.getId());
        queryTeamGoals.setParameter("group_id", (Object)group.getId());
        List resultQueryTeamGoals = queryTeamGoals.list();
        for (Object object : resultQueryTeamGoals) {
            Object[] row = (Object[])object;
            Team team = (Team)row[0];
            int posGoals = ((Long)row[2]).intValue();
            int negGoals = ((Long)row[3]).intValue();
            TeamResult tr = new TeamResult(group, team);
            tr.setNegGoals(negGoals);
            tr.setPosGoals(posGoals);
            resultMap.put(team, tr);
        }
        SQLQuery queryTeamPoints = this.getSessionFactory().getCurrentSession().createSQLQuery(QUERY_TEAM_SEASON_POINTS).addEntity("team", Team.class).addScalar("win", (Type)StandardBasicTypes.LONG).addScalar("remis", (Type)StandardBasicTypes.LONG).addScalar("lost", (Type)StandardBasicTypes.LONG).addScalar("points", (Type)StandardBasicTypes.LONG);
        queryTeamPoints.setParameter("season_id", (Object)season.getId());
        queryTeamPoints.setParameter("group_id", (Object)group.getId());
        List resultQueryTeamPoints = queryTeamPoints.list();
        for (Object object : resultQueryTeamPoints) {
            TeamResult tr;
            Object[] row = (Object[])object;
            Team team = (Team)row[0];
            int win = ((Long)row[1]).intValue();
            int remis = ((Long)row[2]).intValue();
            int lost = ((Long)row[3]).intValue();
            if (resultMap.containsKey(team)) {
                tr = (TeamResult)resultMap.get(team);
                tr.setWin(win);
                tr.setLost(lost);
                tr.setRemis(remis);
                continue;
            }
            tr = new TeamResult(group, team);
            tr.setWin(win);
            tr.setLost(lost);
            tr.setRemis(remis);
            resultMap.put(team, tr);
        }
        return this.teamResultToList(resultMap);
    }

    @Override
    public List<TeamResult> calculateTeamRanking(Season season, Group group, int startIndex, int endIndex) {
        HashMap<Team, TeamResult> resultMap = new HashMap<Team, TeamResult>();
        SQLQuery queryTeamGoals = this.getSessionFactory().getCurrentSession().createSQLQuery(QUERY_TEAM_SEASON_RANGE_GOALS).addEntity("team", Team.class).addScalar("diff", (Type)StandardBasicTypes.LONG).addScalar("pos_goals", (Type)StandardBasicTypes.LONG).addScalar("neg_goals", (Type)StandardBasicTypes.LONG);
        queryTeamGoals.setParameter("season_id", (Object)season.getId());
        queryTeamGoals.setParameter("group_id", (Object)group.getId());
        queryTeamGoals.setParameter("start_index", (Object)startIndex);
        queryTeamGoals.setParameter("end_index", (Object)endIndex);
        List resultQueryTeamGoals = queryTeamGoals.list();
        for (Object object : resultQueryTeamGoals) {
            Object[] row = (Object[])object;
            Team team = (Team)row[0];
            int posGoals = ((Long)row[2]).intValue();
            int negGoals = ((Long)row[3]).intValue();
            TeamResult tr = new TeamResult(group, team);
            tr.setNegGoals(negGoals);
            tr.setPosGoals(posGoals);
            resultMap.put(team, tr);
        }
        SQLQuery queryTeamPoints = this.getSessionFactory().getCurrentSession().createSQLQuery(QUERY_TEAM_SEASON_RANGE_POINTS).addEntity("team", Team.class).addScalar("win", (Type)StandardBasicTypes.LONG).addScalar("remis", (Type)StandardBasicTypes.LONG).addScalar("lost", (Type)StandardBasicTypes.LONG).addScalar("points", (Type)StandardBasicTypes.LONG);
        queryTeamPoints.setParameter("season_id", (Object)season.getId());
        queryTeamPoints.setParameter("group_id", (Object)group.getId());
        queryTeamPoints.setParameter("start_index", (Object)startIndex);
        queryTeamPoints.setParameter("end_index", (Object)endIndex);
        List resultQueryTeamPoints = queryTeamPoints.list();
        for (Object object : resultQueryTeamPoints) {
            TeamResult tr;
            Object[] row = (Object[])object;
            Team team = (Team)row[0];
            int win = ((Long)row[1]).intValue();
            int remis = ((Long)row[2]).intValue();
            int lost = ((Long)row[3]).intValue();
            if (resultMap.containsKey(team)) {
                tr = (TeamResult)resultMap.get(team);
                tr.setWin(win);
                tr.setLost(lost);
                tr.setRemis(remis);
                continue;
            }
            tr = new TeamResult(group, team);
            tr.setWin(win);
            tr.setLost(lost);
            tr.setRemis(remis);
            resultMap.put(team, tr);
        }
        return this.teamResultToList(resultMap);
    }

    private List<TeamResult> teamResultToList(Map<Team, TeamResult> teamResults) {
        ArrayList<TeamResult> tr = new ArrayList<TeamResult>();
        tr.addAll(teamResults.values());
        Collections.sort(tr, new TeamPointsComparator());
        for (int i = 0; i < tr.size(); ++i) {
            ((TeamResult)tr.get(i)).setTabPos(i + 1);
        }
        return tr;
    }
}

