/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.mail;

import de.awtools.basic.LoggerFactory;
import de.awtools.mail.MailUtils;
import de.awtools.mail.POP3Receiver;
import de.winkler.betoffice.mail.MailContent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.Validate;
import org.joda.time.DateTime;
import org.slf4j.Logger;

public class MailDownloadManager {
    private final Logger log = LoggerFactory.make();
    public static final String PROPERTY_MAIL_PARSING = "mailParsing";
    public static final String PROPERTY_MAIL_COUNT = "mailCount";
    public static final String PROPERTY_MAIL_FAILURE = "mailFailure";
    private final POP3Receiver receiver;
    private PropertyChangeSupport propertyChangeSupport;

    public MailDownloadManager(POP3Receiver _receiver) {
        Validate.notNull((Object)_receiver);
        this.receiver = _receiver;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public List<MailContent> readMails() {
        ArrayList<MailContent> mails = new ArrayList<MailContent>();
        this.receiver.download();
        Message[] messages = this.receiver.messagesToArray();
        this.propertyChangeSupport.firePropertyChange(PROPERTY_MAIL_COUNT, 0, messages.length);
        for (int i = 0; i < messages.length; ++i) {
            try {
                String date;
                Message message = messages[i];
                InternetAddress[] inetAdress = (InternetAddress[])message.getFrom();
                String from = null;
                from = inetAdress.length > 0 ? inetAdress[0].getAddress() : "unknwon";
                String subject = message.getSubject();
                String msgTxt = this.extractMailBody(message, i);
                if (message.getSentDate() == null) {
                    date = DateTime.now().toString("yyyy-MM-dd HH:mm:ss");
                } else {
                    DateFormat dateFormatter = DateFormat.getDateInstance(2, new Locale("de", "DE"));
                    date = dateFormatter.format(message.getSentDate());
                }
                if (this.log.isDebugEnabled()) {
                    StringBuilder debug = new StringBuilder();
                    debug.append("+++++Neue Mail: \n\t");
                    debug.append("Address: ");
                    debug.append(from);
                    debug.append("\n\t");
                    debug.append("Text: ");
                    debug.append(msgTxt);
                    debug.append("\n\t");
                    debug.append("Date: ");
                    debug.append(date);
                    debug.append("\n\t");
                    this.log.debug(debug.toString());
                }
                MailContent mailContent = new MailContent(from.trim(), subject.trim(), MailContent.trimMsgTxt(msgTxt).trim(), date.trim());
                mails.add(mailContent);
                this.propertyChangeSupport.firePropertyChange(PROPERTY_MAIL_PARSING, i - 1, i);
                continue;
            }
            catch (IOException ex) {
                this.log.warn("Mail parsing failed. Check your POP3 account!", (Throwable)ex);
                this.propertyChangeSupport.firePropertyChange(PROPERTY_MAIL_FAILURE, -1, i);
                continue;
            }
            catch (MessagingException ex) {
                this.log.warn("Mail parsing failed. Check your POP3 account!", (Throwable)ex);
                this.propertyChangeSupport.firePropertyChange(PROPERTY_MAIL_FAILURE, -1, i);
            }
        }
        return mails;
    }

    private String extractMailBody(Message message, int i) throws MessagingException, IOException {
        String msgTxt = null;
        try {
            msgTxt = MailUtils.getBody((Message)message);
        }
        catch (IOException ex) {
            this.log.warn("Mail body extraction failed with an exception.  The mail will be ignored.", (Throwable)ex);
            msgTxt = "Unknown body type. Mail will be ignored.";
        }
        return msgTxt;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

