/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.GoalDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.Goal;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="goalDao")
public class GoalDaoHibernate
extends AbstractCommonDao<Goal>
implements GoalDao {
    public GoalDaoHibernate() {
        super(Goal.class);
    }

    @Override
    public List<Goal> findAll() {
        return this.getSessionFactory().getCurrentSession().createQuery("from Goal as goal inner join fetch goal.player order by goal.id").list();
    }

    @Override
    public Goal findByOpenligaid(long openligaid) {
        List goals = this.getSessionFactory().getCurrentSession().createQuery("from Goal as goal where goal.openligaid = :openligaid").setLong("openligaid", openligaid).list();
        return (Goal)this.first(goals);
    }

    @Override
    public List<Goal> find(Game match) {
        List goals = this.getSessionFactory().getCurrentSession().createQuery("from Goal as goal where goal.game.id = :matchId").setLong("matchId", match.getId().longValue()).list();
        return goals;
    }
}

