/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.enums.Toto;
import java.io.Serializable;
import org.apache.commons.lang.Validate;

public class GameResult
extends AbstractStorageObject
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4527677284167591700L;
    private int homeGoals = 0;
    private int guestGoals = 0;
    private Toto toto = Toto.REMIS;

    public GameResult() {
    }

    public GameResult(int home, int guest) {
        Validate.isTrue((home >= 0 ? 1 : 0) != 0);
        Validate.isTrue((guest >= 0 ? 1 : 0) != 0);
        this.setHomeGoals(home);
        this.setGuestGoals(guest);
    }

    public GameResult(GameResult gameResult) {
        this(gameResult.getHomeGoals(), gameResult.getGuestGoals());
    }

    public int getHomeGoals() {
        return this.homeGoals;
    }

    private void setHomeGoals(int home) {
        this.homeGoals = home;
        this.setToto();
    }

    public int getGuestGoals() {
        return this.guestGoals;
    }

    private void setGuestGoals(int guest) {
        this.guestGoals = guest;
        this.setToto();
    }

    public Toto getToto() {
        return this.toto;
    }

    private void setToto() {
        if (this.homeGoals > this.guestGoals) {
            this.toto = Toto.HOME_WIN;
        } else if (this.homeGoals == this.guestGoals) {
            this.toto = Toto.REMIS;
        } else if (this.homeGoals < this.guestGoals) {
            this.toto = Toto.HOME_LOST;
        }
    }

    public boolean isValid() {
        return true;
    }

    public boolean compare(GameResult result) {
        if (result == null) {
            return false;
        }
        return result.getHomeGoals() == this.homeGoals && result.getGuestGoals() == this.guestGoals;
    }

    public Object clone() throws CloneNotSupportedException {
        GameResult res = new GameResult();
        res.homeGoals = this.homeGoals;
        res.guestGoals = this.guestGoals;
        res.toto = this.toto;
        return res;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof GameResult)) {
            return false;
        }
        GameResult gr = (GameResult)object;
        return this.getHomeGoals() == gr.getHomeGoals() && this.getGuestGoals() == gr.getGuestGoals();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getHomeGoals();
        result = 37 * result + this.getGuestGoals();
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.homeGoals);
        buf.append(':');
        buf.append(this.guestGoals);
        return buf.toString();
    }
}

