/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.GroupDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import java.util.List;
import org.hibernate.SQLQuery;
import org.springframework.stereotype.Repository;

@Repository(value="groupDao")
public class GroupDaoHibernate
extends AbstractCommonDao<Group>
implements GroupDao {
    private static final String QUERY_GROUPS_FROM_SEASON = AbstractCommonDao.loadQuery("hql_groups_season.sql");
    private static final String QUERY_TEAMS_BY_GROUP = AbstractCommonDao.loadQuery("query_teams_group.sql");

    public GroupDaoHibernate() {
        super(Group.class);
    }

    @Override
    public List<Group> findAll() {
        List groups = this.getSessionFactory().getCurrentSession().createQuery("from group").list();
        return groups;
    }

    @Override
    public List<Group> findBySeason(Season season) {
        List objects = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GROUPS_FROM_SEASON).setParameter("seasonId", (Object)season.getId()).list();
        return objects;
    }

    @Override
    public List<Team> findTeams(Group group) {
        SQLQuery query = this.getSessionFactory().getCurrentSession().createSQLQuery(QUERY_TEAMS_BY_GROUP).addEntity("team", Team.class);
        query.setParameter("group_id", (Object)group.getId());
        List teams = query.list();
        return teams;
    }
}

