/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.PlayerDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Player;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="playerDao")
public class PlayerDaoHibernate
extends AbstractCommonDao<Player>
implements PlayerDao {
    public PlayerDaoHibernate() {
        super(Player.class);
    }

    @Override
    public List<Player> findAll() {
        return this.getSessionFactory().getCurrentSession().createQuery("from Player as player order by player.name").list();
    }

    @Override
    public Player findByOpenligaid(long openligaid) {
        List players = this.getSessionFactory().getCurrentSession().createQuery("from Player as player where player.openligaid = :openligaid").setLong("openligaid", openligaid).list();
        return (Player)this.first(players);
    }

    @Override
    public Player findAllGoalsOfPlayer(long id) {
        List players = this.getSessionFactory().getCurrentSession().createQuery("from Player as player left join fetch player.goals where player.id = :id").setLong("id", id).list();
        return (Player)this.first(players);
    }
}

