/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.service.AbstractManagerService;
import de.winkler.betoffice.service.SeasonManagerService;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.Goal;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Player;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.TeamResult;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResult;
import de.winkler.betoffice.storage.UserSeason;
import de.winkler.betoffice.validation.BetofficeValidationException;
import de.winkler.betoffice.validation.BetofficeValidationMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="seasonManagerService")
public class DefaultSeasonManagerService
extends AbstractManagerService
implements SeasonManagerService {
    @Override
    @Transactional(readOnly=true)
    public List<UserResult> calculateUserRanking(GameList round) {
        List<User> users = this.getConfig().getUserSeasonDao().findUsers(round.getSeason());
        return this.getConfig().getUserDao().calculateUserRanking(users, round);
    }

    @Override
    @Transactional(readOnly=true)
    public List<UserResult> calculateUserRanking(Season season, int startIndex, int endIndex) {
        List<User> users = this.getConfig().getUserSeasonDao().findUsers(season);
        return this.getConfig().getUserDao().calculateUserRanking(users, season, startIndex, endIndex);
    }

    @Override
    @Transactional(readOnly=true)
    public List<UserResult> calculateUserRanking(Season season) {
        List<User> users = this.getConfig().getUserSeasonDao().findUsers(season);
        return this.getConfig().getUserDao().calculateUserRanking(users, season);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeamResult> calculateTeamRanking(Season season, Group group) {
        return this.getConfig().getSeasonDao().calculateTeamRanking(season, group);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeamResult> calculateTeamRanking(Season season, Group group, int startIndex, int endIndex) {
        return this.getConfig().getSeasonDao().calculateTeamRanking(season, group, startIndex, endIndex);
    }

    @Override
    @Transactional(readOnly=true)
    public List<User> findActivatedUsers(Season season) {
        return this.getConfig().getUserSeasonDao().findUsers(season);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Season> findAllSeasons() {
        return this.getConfig().getSeasonDao().findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public List<Team> findTeamsByGroup(Group group) {
        return this.getConfig().getGroupDao().findTeams(group);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Team> findTeamsByGroupType(Season season, GroupType groupType) {
        return this.getConfig().getTeamDao().findTeamsBySeasonAndGroup(season, groupType);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GroupType> findGroupTypesBySeason(Season season) {
        return this.getConfig().getGroupTypeDao().findBySeason(season);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Game> findMatches(Team homeTeam, Team guestTeam) {
        return this.getConfig().getMatchDao().find(homeTeam, guestTeam);
    }

    @Override
    @Transactional(readOnly=true)
    public Game findMatch(GameList round, Team homeTeam, Team guestTeam) {
        return this.getConfig().getMatchDao().find(round, homeTeam, guestTeam);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Game> findMatches(Team homeTeam, Team guestTeam, boolean spin) {
        ArrayList<Game> results = new ArrayList<Game>();
        if (spin) {
            results.addAll(this.getConfig().getMatchDao().findAll(homeTeam, guestTeam));
        } else {
            results.addAll(this.getConfig().getMatchDao().find(homeTeam, guestTeam));
        }
        return results;
    }

    @Override
    @Transactional(readOnly=true)
    public GameList findRound(Season season, int index) {
        return this.getConfig().getRoundDao().findRound(season, index);
    }

    @Override
    @Transactional(readOnly=true)
    public GameList findRoundById(long id) {
        return this.getConfig().getRoundDao().findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public GameList findNextRound(long id) {
        Long nextRoundId = this.getConfig().getRoundDao().findNext(id);
        GameList nextGameList = null;
        if (nextRoundId != null) {
            nextGameList = this.getConfig().getRoundDao().findById(nextRoundId);
        }
        return nextGameList;
    }

    @Override
    @Transactional(readOnly=true)
    public GameList findPrevRound(long id) {
        Long prevRoundId = this.getConfig().getRoundDao().findPrevious(id);
        GameList prevGameList = null;
        if (prevRoundId != null) {
            prevGameList = this.getConfig().getRoundDao().findById(prevRoundId);
        }
        return prevGameList;
    }

    @Override
    @Transactional(readOnly=true)
    public List<GameList> findRounds(Season season) {
        return this.getConfig().getRoundDao().findRounds(season);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Group> findGroups(Season season) {
        return this.getConfig().getGroupDao().findBySeason(season);
    }

    @Override
    @Transactional(readOnly=true)
    public Season findRoundGroupTeamUserRelations(Season season) {
        return this.getConfig().getSeasonDao().findRoundGroupTeamUser(season);
    }

    @Override
    @Transactional(readOnly=true)
    public Season findRoundGroupTeamUserTippRelations(Season season) {
        return this.getConfig().getSeasonDao().findRoundGroupTeamUserTipp(season);
    }

    @Override
    @Transactional(readOnly=true)
    public Season findSeasonByName(String name, String year) {
        return this.getConfig().getSeasonDao().findByName(name, year);
    }

    @Override
    @Transactional(readOnly=true)
    public Season findSeasonById(long id) {
        return this.getConfig().getSeasonDao().findById(id);
    }

    @Override
    @Transactional
    public Game addMatch(GameList round, DateTime date, Group group, Team homeTeam, Team guestTeam) {
        Game match = new Game();
        match.setDateTime(date.toDate());
        match.setHomeTeam(homeTeam);
        match.setGuestTeam(guestTeam);
        match.setGroup(group);
        round.addGame(match);
        this.getConfig().getMatchDao().save(match);
        return match;
    }

    @Override
    @Transactional
    public Game addMatch(GameList round, DateTime date, Group group, Team homeTeam, Team guestTeam, int homeGoals, int guestGoals) {
        Game match = new Game();
        match.setDateTime(date.toDate());
        match.setHomeTeam(homeTeam);
        match.setGuestTeam(guestTeam);
        match.setGroup(group);
        match.setResult(homeGoals, guestGoals);
        match.setPlayed(true);
        round.addGame(match);
        this.getConfig().getMatchDao().save(match);
        return match;
    }

    @Override
    @Transactional
    public Game addMatch(Season season, int round, DateTime date, GroupType groupType, Team homeTeam, Team guestTeam) {
        return this.addMatch(season.getGamesOfDay(round), date, season.getGroup(groupType), homeTeam, guestTeam);
    }

    @Override
    @Transactional
    public Game addMatch(Season season, int round, DateTime date, GroupType groupType, Team homeTeam, Team guestTeam, int homeGoals, int guestGoals) {
        return this.addMatch(season.getGamesOfDay(round), date, season.getGroup(groupType), homeTeam, guestTeam, homeGoals, guestGoals);
    }

    @Override
    @Transactional
    public GameList addRound(Season season, DateTime date, GroupType groupType) {
        GameList round = new GameList();
        round.setDateTime(date.toDate());
        round.setGroup(season.getGroup(groupType));
        season.addGameList(round);
        this.getConfig().getRoundDao().save(round);
        return round;
    }

    @Override
    @Transactional
    public void addTeam(Season season, GroupType groupType, Team team) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (!season.getTeamType().equals((Object)team.getTeamType())) {
            messages.add(new BetofficeValidationMessage("Der Meisterschaft sind Teilnehmer zugeordnet.", null, BetofficeValidationMessage.Severity.ERROR));
        }
        if (messages.size() != 0) {
            throw new BetofficeValidationException(messages);
        }
        Group group = season.getGroup(groupType);
        group.addTeam(team);
        this.getConfig().getGroupDao().update(group);
    }

    @Override
    @Transactional
    public void addTeams(Season season, GroupType groupType, Collection<Team> teams) {
        for (Team team : teams) {
            this.addTeam(season, groupType, team);
        }
    }

    @Override
    @Transactional
    public void addUsers(Season season, Collection<User> users) {
        List<User> activeUsers = this.findActivatedUsers(season);
        Season season2 = this.findRoundGroupTeamUserRelations(season);
        for (User user : users) {
            if (activeUsers.contains(user)) continue;
            UserSeason userSeason = new UserSeason();
            userSeason.setUser(user);
            season2.addUser(userSeason);
            this.getConfig().getUserSeasonDao().save(userSeason);
        }
    }

    @Override
    @Transactional
    public void createSeason(Season season) {
        this.getConfig().getSeasonDao().save(season);
    }

    @Override
    @Transactional
    public void deleteSeason(Season season) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (this.findActivatedUsers(season).size() > 0) {
            messages.add(new BetofficeValidationMessage("Der Meisterschaft sind Teilnehmer zugeordnet.", null, BetofficeValidationMessage.Severity.ERROR));
        }
        if (this.findRounds(season).size() > 0) {
            messages.add(new BetofficeValidationMessage("Der Meisterschaft sind Spieltage zugeordnet.", null, BetofficeValidationMessage.Severity.ERROR));
        }
        if (this.findGroups(season).size() > 0) {
            messages.add(new BetofficeValidationMessage("Der Meisterschaft sind Gruppen zugordnet.", null, BetofficeValidationMessage.Severity.ERROR));
        }
        if (messages.size() != 0) {
            throw new BetofficeValidationException(messages);
        }
        this.getConfig().getSeasonDao().delete(season);
    }

    @Override
    @Transactional
    public void removeMatch(Game match) {
        match.getGameList().removeGame(match);
        this.getConfig().getMatchDao().delete(match);
    }

    @Override
    @Transactional
    public void removeRound(Season season, GameList round) {
        season.removeGameList(round);
        this.getConfig().getRoundDao().delete(round);
    }

    @Override
    @Transactional
    public void removeTeam(Season season, GroupType groupType, Team team) {
        Group group = season.getGroup(groupType);
        group.removeTeam(team);
        this.getConfig().getGroupDao().update(group);
    }

    @Override
    @Transactional
    public void removeTeams(Season season, GroupType groupType, Collection<Team> teams) {
        for (Team team : teams) {
            this.removeTeam(season, groupType, team);
        }
    }

    @Override
    @Transactional
    public void removeUsers(Season season, Collection<User> users) {
        List<User> activeUsers = season.getUsers();
        for (User user : users) {
            if (!activeUsers.contains(user)) continue;
            UserSeason userSeason = season.removeUser(user);
            this.getConfig().getUserSeasonDao().delete(userSeason);
        }
    }

    @Override
    @Transactional
    public void updateMatch(Game match) {
        this.getConfig().getMatchDao().update(match);
    }

    @Override
    @Transactional
    public void updateMatch(Collection<Game> modifiedMatches) {
        for (Game match : modifiedMatches) {
            this.getConfig().getMatchDao().update(match);
        }
    }

    @Override
    @Transactional
    public void updateSeason(Season season) {
        this.getConfig().getSeasonDao().update(season);
    }

    @Override
    @Transactional
    public Group addGroupType(Season season, GroupType groupType) {
        if (season == null) {
            throw new IllegalArgumentException("Parameter season is null!");
        }
        if (groupType == null) {
            throw new IllegalArgumentException("Parameter groupType is null!");
        }
        Group group = season.getGroup(groupType);
        if (group == null) {
            group = new Group();
            group.setGroupType(groupType);
            season.addGroup(group);
            this.getConfig().getGroupDao().save(group);
        }
        return group;
    }

    @Override
    @Transactional
    public void addGroupType(Season season, Collection<GroupType> groupTypes) {
        for (GroupType groupType : groupTypes) {
            this.addGroupType(season, groupType);
        }
    }

    @Override
    @Transactional
    public void removeGroupType(Season season, GroupType groupType) {
        if (season.getGroup(groupType) != null) {
            Group group = season.removeGroup(groupType);
            this.getConfig().getGroupDao().delete(group);
        }
    }

    @Override
    @Transactional
    public void removeGroupType(Season season, Collection<GroupType> groupTypes) {
        for (GroupType groupType : groupTypes) {
            this.removeGroupType(season, groupType);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<GameTipp> findTippsByRoundAndUser(GameList round, User user) {
        return this.getConfig().getGameTippDao().findTippsByRoundAndUser(round, user);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GameTipp> findTippsByMatch(Game match) {
        return this.getConfig().getGameTippDao().findByMatch(match);
    }

    @Override
    @Transactional(readOnly=false)
    public Player findGoalsOfPlayer(long id) {
        return this.getConfig().getPlayerDao().findAllGoalsOfPlayer(id);
    }

    @Override
    @Transactional
    public void addGoal(Game match, Goal goal) {
        match.addGoal(goal);
        goal.setGame(match);
        this.getConfig().getMatchDao().save(match);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Goal> findAllGoals() {
        return this.getConfig().getGoalDao().findAll();
    }
}

