/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.RoundDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.Season;
import java.math.BigInteger;
import java.util.List;
import org.hibernate.query.NativeQuery;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

@Repository(value="roundDao")
public class RoundDaoHibernate
extends AbstractCommonDao<GameList>
implements RoundDao {
    private static final String QUERY_GAMELIST_BY_SEASON = "from GameList as gamelist where gamelist.season.id = :seasonId order by gamelist.index";
    private static final String QUERY_LAST_GAMELIST_BY_SEASON = "from GameList as gamelist where gamelist.season.id = :seasonId and gamelist.index = ( select max(index) from gamelist gl2 where  gl2.season.id = :seasonId )";
    private static final String QUERY_GAMELIST_BY_SEASON_GROUP = "from GameList as gamelist where gamelist.season.id = :seasonId and gamelist.group.id = :groupId order by gamelist.index";
    private static final String QUERY_GAMELIST_BY_SEASON_AND_INDEX = "from GameList as gamelist where gamelist.season.id = :seasonId and gamelist.index = :gameListIndex";
    private static final String QUERY_ALL_ROUND_OBJECTS = "select round from GameList as round left join fetch round.gameList game left join fetch game.tippList tipp left join fetch tipp.user u left join fetch game.homeTeam left join fetch game.guestTeam left join fetch game.group where round.season.id = :seasonId and round.index = :gameListIndex";
    private static final String QUERY_NEXT_ROUND_BY_DATE = "select min(t.bo_datetime) datetime, t.id next_round_id from (select r.bo_datetime, r.id from bo_gamelist r, bo_game m where r.bo_season_ref = :season_id and r.id = m.bo_gamelist_ref and m.bo_datetime >= :date) as t";
    private static final String QUERY_NEXT_ROUND = AbstractCommonDao.loadQuery("query_next_round.sql");
    private static final String QUERY_PREV_ROUND = AbstractCommonDao.loadQuery("query_prev_round.sql");

    public RoundDaoHibernate() {
        super(GameList.class);
    }

    @Override
    public List<GameList> findRounds(Season season) {
        List objects = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMELIST_BY_SEASON).setParameter("seasonId", (Object)season.getId()).list();
        return objects;
    }

    @Override
    public List<GameList> findRounds(Season season, Group group) {
        List objects = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMELIST_BY_SEASON_GROUP).setParameter("seasonId", (Object)season.getId()).setParameter("groupId", (Object)group.getId()).list();
        return objects;
    }

    @Override
    public GameList findRound(Season season, int index) {
        List rounds = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMELIST_BY_SEASON_AND_INDEX).setParameter("seasonId", (Object)season.getId()).setParameter("gameListIndex", (Object)index).list();
        GameList result = null;
        if (!rounds.isEmpty()) {
            result = (GameList)rounds.get(0);
        }
        return result;
    }

    @Override
    public GameList findAllRoundObjects(Season season, int index) {
        List rounds = this.getSessionFactory().getCurrentSession().createQuery(QUERY_ALL_ROUND_OBJECTS).setParameter("seasonId", (Object)season.getId()).setParameter("gameListIndex", (Object)index).list();
        return (GameList)rounds.get(0);
    }

    @Override
    public Long findNextTippRound(long seasonId, DateTime date) {
        NativeQuery query = this.getSessionFactory().getCurrentSession().createSQLQuery(QUERY_NEXT_ROUND_BY_DATE);
        query.setParameter("season_id", (Object)seasonId);
        query.setDate("date", date.toDate());
        query.addScalar("datetime");
        query.addScalar("next_round_id");
        Object[] uniqueResult = (Object[])query.uniqueResult();
        Long roundId = null;
        if (uniqueResult != null && uniqueResult[1] != null) {
            roundId = ((BigInteger)uniqueResult[1]).longValue();
        }
        return roundId;
    }

    @Override
    public Long findNext(long id) {
        NativeQuery query = this.getSessionFactory().getCurrentSession().createSQLQuery(QUERY_NEXT_ROUND);
        query.setParameter("roundId", (Object)id);
        query.addScalar("next_round_id");
        BigInteger uniqueResult = (BigInteger)query.uniqueResult();
        Long nextRoundId = null;
        if (uniqueResult != null) {
            nextRoundId = uniqueResult.longValue();
        }
        return nextRoundId;
    }

    @Override
    public Long findPrevious(long id) {
        NativeQuery query = this.getSessionFactory().getCurrentSession().createSQLQuery(QUERY_PREV_ROUND);
        query.setParameter("roundId", (Object)id);
        query.addScalar("prev_round_id");
        BigInteger uniqueResult = (BigInteger)query.uniqueResult();
        Long prevRoundId = null;
        if (uniqueResult != null) {
            prevRoundId = uniqueResult.longValue();
        }
        return prevRoundId;
    }

    @Override
    public GameList findLastRound(Season season) {
        List rounds = this.getSessionFactory().getCurrentSession().createQuery(QUERY_LAST_GAMELIST_BY_SEASON).setParameter("seasonId", (Object)season.getId()).list();
        GameList result = null;
        if (!rounds.isEmpty()) {
            result = (GameList)rounds.get(0);
        }
        return result;
    }
}

