/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.TeamAliasDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.TeamAlias;
import java.util.List;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;

@Repository(value="teamAliasDao")
public class TeamAliasDaoHibernate
extends AbstractCommonDao<TeamAlias>
implements TeamAliasDao {
    private static final String QUERY_TEAMALIAS_BY_NAME = "select t.id, t.bo_name, t.bo_longname, t.bo_logo, t.bo_teamtype, t.bo_location_ref, t.bo_openligaid from bo_team t, bo_teamalias ta where ta.bo_aliasname like :alias_name   and ta.bo_team_ref = t.id";
    private static final String QUERY_TEAMALIAS_BY_TEAM = "from " + TeamAlias.class.getName() + " as alias " + "where alias.team.id = :teamId";
    private static final String QUERY_TEAMALIAS_FINDALL = "from " + TeamAlias.class.getName() + " order by bo_aliasName";

    public TeamAliasDaoHibernate() {
        super(TeamAlias.class);
    }

    @Override
    public List<TeamAlias> findAll() {
        return this.getSessionFactory().getCurrentSession().createQuery(QUERY_TEAMALIAS_FINDALL).list();
    }

    @Override
    public Team findByAliasName(String aliasName) {
        NativeQuery query = this.getSessionFactory().getCurrentSession().createSQLQuery(QUERY_TEAMALIAS_BY_NAME).addEntity("team", Team.class).setParameter("alias_name", (Object)aliasName);
        List objects = query.list();
        if (objects.size() == 0) {
            return null;
        }
        return (Team)objects.get(0);
    }

    @Override
    public List<TeamAlias> findAliasNames(Team team) {
        List teams = this.getSessionFactory().getCurrentSession().createQuery(QUERY_TEAMALIAS_BY_TEAM).setParameter("teamId", (Object)team.getId()).list();
        return teams;
    }
}

