/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.mail;

import de.awtools.basic.LoggerFactory;
import de.winkler.betoffice.mail.MailContent;
import de.winkler.betoffice.mail.MailContentDetails;
import de.winkler.betoffice.mail.MailException;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;

public class MailXMLParser {
    public static final String REGISTRATION = "Anmeldung";
    public static final String TIPP = "Tipp";
    private final Logger log = LoggerFactory.make();

    public MailContentDetails parse(MailContent mailContent) throws MailException {
        try {
            MailContentDetails detail = new MailContentDetails();
            String message = MailContent.trimMsgTxt(mailContent.sMessageText);
            Element element = DocumentHelper.parseText((String)message).getRootElement();
            this.startParsing(detail, element);
            return detail;
        }
        catch (DocumentException ex) {
            this.log.info("Parsing exception!", (Throwable)ex);
            throw new MailException((Exception)((Object)ex));
        }
    }

    private void startParsing(MailContentDetails content, Element element) {
        content.setDate(element.elementTextTrim("DATUM"));
        content.setBrowser(element.elementTextTrim("BROWSER"));
        content.setMail(element.elementTextTrim("EMAIL"));
        content.setFormInfo(element.elementTextTrim("FORMINFO"));
        content.setChampionship(element.elementTextTrim("CHAMPIONSHIP"));
        content.setRound(element.elementTextTrim("ROUND"));
        content.setGuestGoals(element.elementTextTrim("GUESTGOALS"));
        content.setHomeGoals(element.elementTextTrim("HOMEGOALS"));
        content.setNickName(element.elementTextTrim("NICKNAME"));
        content.setPhone(element.elementTextTrim("PHONE"));
        content.setPwdA(element.elementTextTrim("PWDA"));
        content.setPwdB(element.elementTextTrim("PWDB"));
        content.setTime(element.elementTextTrim("TIME"));
        content.setUsing(element.elementTextTrim("USE"));
        content.setUser(element.elementTextTrim("USER"));
        content.setUserCall(element.elementTextTrim("USERCALL"));
        content.setUserIP(element.elementTextTrim("USERIP"));
    }
}

