/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.awtools.basic.LoggerFactory;
import de.winkler.betoffice.dao.SessionDao;
import de.winkler.betoffice.dao.UserDao;
import de.winkler.betoffice.service.AuthService;
import de.winkler.betoffice.service.SecurityToken;
import de.winkler.betoffice.storage.Session;
import de.winkler.betoffice.storage.User;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="authService")
public class DefaultAuthService
implements AuthService {
    private final Logger log = LoggerFactory.make();
    @Autowired
    private UserDao userDao;
    @Autowired
    private SessionDao sessionDao;

    @Override
    @Transactional
    public SecurityToken login(String name, String password, String sessionId, String address, String browserId) {
        User user = this.userDao.findByNickname(name);
        DateTime now = DateTime.now();
        SecurityToken securityToken = null;
        if (user != null && user.comparePwd(password)) {
            securityToken = new SecurityToken(sessionId, user, SecurityToken.Role.TIPPER, now);
            Session session = new Session();
            session.setBrowser(browserId);
            session.setFailedLogins(0);
            session.setLogin(now.toDate());
            session.setLogout(null);
            session.setNickname(name);
            session.setRemoteAddress(address);
            session.setToken(securityToken.getToken());
            session.setUser(user);
            this.sessionDao.save(session);
        }
        return securityToken;
    }

    @Override
    @Transactional
    public void logout(SecurityToken securityToken) {
        List<Session> sessions = this.sessionDao.findBySessionId(securityToken.getToken());
        if (sessions.isEmpty()) {
            this.log.warn("Trying to logout with invalid securityToken=[{}]", (Object)securityToken);
        } else {
            for (Session session : sessions) {
                session.setLogout(DateTime.now().toDate());
                this.sessionDao.save(session);
            }
        }
    }
}

