/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.awtools.basic.AWTools;
import de.awtools.basic.LoggerFactory;
import de.winkler.betoffice.dao.RoundDao;
import de.winkler.betoffice.mail.DefaultBetofficeMailer;
import de.winkler.betoffice.mail.MailContentDetails;
import de.winkler.betoffice.mail.TippMail;
import de.winkler.betoffice.mail.TippMailParameter;
import de.winkler.betoffice.mail.TippToInfoMailConverter;
import de.winkler.betoffice.mail.TippToXmlConverter;
import de.winkler.betoffice.service.AbstractManagerService;
import de.winkler.betoffice.service.TippDto;
import de.winkler.betoffice.service.TippService;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.enums.TippStatusType;
import de.winkler.betoffice.storage.exception.StorageObjectNotFoundException;
import de.winkler.betoffice.validation.BetofficeValidationException;
import de.winkler.betoffice.validation.BetofficeValidationMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tippService")
public class DefaultTippService
extends AbstractManagerService
implements TippService {
    private final Logger log = LoggerFactory.make();

    @Override
    @Transactional
    public GameTipp addTipp(Game match, User user, GameResult gr, TippStatusType status) {
        GameTipp gameTipp = match.addTipp(user, gr, status);
        this.getConfig().getGameTippDao().save(gameTipp);
        return gameTipp;
    }

    @Override
    @Transactional
    public void addTipp(GameList round, User user, List<GameResult> tipps, TippStatusType status) {
        for (int i = 0; i < round.size(); ++i) {
            this.addTipp(round.get(i), user, tipps.get(i), status);
        }
    }

    @Override
    @Transactional
    public void addTipp(TippDto tippDto) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        User user = this.getConfig().getUserDao().findByNickname(tippDto.getNickname());
        if (user == null) {
            BetofficeValidationMessage msg = new BetofficeValidationMessage("Unknown user with nickname=[" + tippDto.getNickname() + "]", null, BetofficeValidationMessage.Severity.INFO);
            messages.add(msg);
            throw new BetofficeValidationException(messages);
        }
        GameList gameList = this.getConfig().getRoundDao().findById(tippDto.getRoundId());
        if (gameList == null) {
            BetofficeValidationMessage msg = new BetofficeValidationMessage("The roundId=[" + tippDto.getRoundId() + "] is invalid.", null, BetofficeValidationMessage.Severity.ERROR);
            messages.add(msg);
            throw new BetofficeValidationException(messages);
        }
        for (TippDto.GameTippDto tipp : tippDto.getGameTipps()) {
            Game game = this.getConfig().getMatchDao().findById(tipp.getGameId());
            GameTipp gameTipp = game.addTipp(user, new GameResult(tipp.getHomeGoals(), tipp.getGuestGoals()), TippStatusType.USER);
            this.getConfig().getGameTippDao().save(gameTipp);
        }
    }

    @Override
    @Transactional
    public void updateTipp(Game match, User user, GameResult gr, TippStatusType status) {
        this.getConfig().getMatchDao().refresh(match);
        this.addTipp(match, user, gr, status);
    }

    @Override
    @Transactional
    public void updateTipp(List<GameTipp> tipps) {
        for (GameTipp tipp : tipps) {
            this.getConfig().getGameTippDao().update(tipp);
        }
    }

    @Override
    @Transactional
    public void removeTipp(Game match, User user) {
        try {
            GameTipp gameTipp = match.getGameTipp(user);
            match.removeTipp(gameTipp);
            this.getConfig().getGameTippDao().delete(gameTipp);
        }
        catch (StorageObjectNotFoundException ex) {
            this.log.info("Zu der Spielpaarung " + match + " besitzt der User " + user + " keine Spieltipps.");
            this.log.info("Der L\u00f6schvorgang wurde nicht durchgef\u00fchrt!");
        }
    }

    @Override
    @Transactional
    public void evaluateMailTipp(Season season, MailContentDetails mail) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (!mail.getUsing().startsWith("Tipp")) {
            BetofficeValidationMessage msg = new BetofficeValidationMessage("Mail is not a 'betoffice tipp' mail. Check the mail format.", null, BetofficeValidationMessage.Severity.INFO);
            messages.add(msg);
            throw new BetofficeValidationException(messages);
        }
        User user = this.getConfig().getUserDao().findByNickname(mail.getNickName());
        if (user == null) {
            BetofficeValidationMessage msg = new BetofficeValidationMessage("Unknown user with nickname ->" + mail.getNickName() + "<-.", null, BetofficeValidationMessage.Severity.INFO);
            messages.add(msg);
            throw new BetofficeValidationException(messages);
        }
        if (!user.getPassword().equals(mail.getPwdA())) {
            BetofficeValidationMessage msg = new BetofficeValidationMessage("Password does not match!", null, BetofficeValidationMessage.Severity.INFO);
            messages.add(msg);
            throw new BetofficeValidationException(messages);
        }
        long championshipId = Long.parseLong(mail.getChampionship());
        if (season.getId() != championshipId) {
            BetofficeValidationMessage msg = new BetofficeValidationMessage("The championship id of the tipp mail ->" + mail.getChampionship() + "<- is not equal to the expected championship from" + " the parameter ->" + season + "<-.", null, BetofficeValidationMessage.Severity.ERROR);
            messages.add(msg);
            throw new BetofficeValidationException(messages);
        }
        int roundIndex = Integer.parseInt(mail.getRound());
        if (roundIndex < 1) {
            throw new NumberFormatException("Round is smaller then 1!");
        }
        GameList round = this.getConfig().getRoundDao().findAllRoundObjects(season, roundIndex - 1);
        if (round == null) {
            throw new RuntimeException("Unable to find the specified round ->" + roundIndex + "<- of championship: ->" + season + "<-.");
        }
        StringTokenizer tokHome = new StringTokenizer(mail.getHomeGoals() + ",", ",");
        StringTokenizer tokGuest = new StringTokenizer(mail.getGuestGoals() + ",", ",");
        if (tokHome.countTokens() != tokGuest.countTokens()) {
            throw new RuntimeException("Mail contains has an invalid format.");
        }
        int gameNr = 0;
        int home = 0;
        int guest = 0;
        while (tokHome.hasMoreTokens()) {
            Game game = null;
            try {
                game = round.get(gameNr);
            }
            catch (IndexOutOfBoundsException ex) {
                this.log.error("Vorgang abgebrochen!", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            String _st1 = tokHome.nextToken();
            String _st2 = tokGuest.nextToken();
            if (this.log.isDebugEnabled()) {
                StringBuilder debug = new StringBuilder("Spiel-Index: ");
                debug.append(gameNr);
                debug.append(IOUtils.LINE_SEPARATOR);
                debug.append("Spiel-toString: ");
                debug.append(game.toString());
                debug.append(IOUtils.LINE_SEPARATOR);
                debug.append("Tipp: ");
                debug.append(_st1);
                debug.append(":");
                debug.append(_st2);
                this.log.debug(debug.toString());
            }
            try {
                home = Integer.parseInt(_st1.trim());
                guest = Integer.parseInt(_st2.trim());
            }
            catch (NumberFormatException ex) {
                this.log.error("Catched a NumberFormatException exception.", (Throwable)ex);
                throw new RuntimeException(ex);
            }
            game.addTipp(user, new GameResult(home, guest), TippStatusType.USER);
            ++gameNr;
        }
        this.getConfig().getRoundDao().save(round);
    }

    @Override
    @Transactional
    public void sendMailTipp(User user, TippMailParameter tippMailParameter) {
        long championshipId = tippMailParameter.getChampionshipId();
        int roundNr = tippMailParameter.getRoundNr();
        Season season = this.getConfig().getSeasonDao().findById(championshipId);
        if (season == null) {
            throw new RuntimeException("Unknown season id=" + championshipId);
        }
        GameList round = this.getConfig().getRoundDao().findRound(season, roundNr - 1);
        if (round == null) {
            throw new RuntimeException("Unknown round nr=" + roundNr);
        }
        TippToXmlConverter tippToXmlConverter = new TippToXmlConverter();
        TippToInfoMailConverter tippToInfoMailConverter = new TippToInfoMailConverter();
        DefaultBetofficeMailer dbm = new DefaultBetofficeMailer();
        TippMail tippXmlMail = tippToXmlConverter.createTippMail(tippMailParameter);
        TippMail tippInfoMail = tippToInfoMailConverter.createTippMail(tippMailParameter);
        MailContentDetails mail = new MailContentDetails();
        mail.setUsing("Tipp");
        mail.setNickName(user.getNickName());
        mail.setPwdA(user.getPassword());
        mail.setPwdB(user.getPassword());
        mail.setChampionship(Long.toString(championshipId));
        mail.setRound(Integer.toString(roundNr));
        mail.setHomeGoals(AWTools.toString((int[])tippMailParameter.getHomeGoals()));
        mail.setGuestGoals(AWTools.toString((int[])tippMailParameter.getGuestGoals()));
        this.evaluateMailTipp(season, mail);
        String mailToBetoffice = "betoffice@andre-winkler.de";
        String mailToUser = user.getEmail();
        try {
            dbm.sendMail("betoffice@andre-winkler.de", tippXmlMail);
            dbm.sendMail(mailToUser, tippInfoMail);
            dbm.sendMail("gluehloch@googlemail.com", tippInfoMail);
        }
        catch (MessagingException ex) {
            this.log.error("Mail system is not available.", (Throwable)ex);
        }
    }

    @Override
    @Transactional
    public List<GameTipp> findTippsByRoundAndUser(GameList round, User user) {
        return this.getConfig().getGameTippDao().findTippsByRoundAndUser(round, user);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GameTipp> findTippsByMatch(Game match) {
        return this.getConfig().getGameTippDao().findByMatch(match);
    }

    @Override
    @Transactional(readOnly=true)
    public GameList findTippRound(long seasonId, DateTime date) {
        RoundDao roundDao = this.getConfig().getRoundDao();
        Long roundId = roundDao.findNextTippRound(seasonId, date);
        if (roundId != null) {
            return roundDao.findById(roundId);
        }
        return null;
    }
}

