/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.service.AbstractManagerService;
import de.winkler.betoffice.service.MasterDataManagerService;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Location;
import de.winkler.betoffice.storage.Player;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.TeamAlias;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.enums.TeamType;
import de.winkler.betoffice.validation.BetofficeValidationException;
import de.winkler.betoffice.validation.BetofficeValidationMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="masterDataManagerService")
public class DefaultMasterDataManagerService
extends AbstractManagerService
implements MasterDataManagerService {
    @Override
    @Transactional
    public void createSeason(Season season) {
        this.getConfig().getSeasonDao().save(season);
    }

    @Override
    @Transactional
    public void updateSeason(Season season) {
        this.getConfig().getSeasonDao().update(season);
    }

    @Override
    @Transactional
    public void createGroupType(GroupType groupType) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (StringUtils.isBlank((String)groupType.getName())) {
            messages.add(new BetofficeValidationMessage("Name ist nicht gesetzt.", "nickName", BetofficeValidationMessage.Severity.ERROR));
        }
        if (!messages.isEmpty()) {
            throw new BetofficeValidationException(messages);
        }
        this.getConfig().getGroupTypeDao().save(groupType);
    }

    @Override
    @Transactional
    public void createTeam(Team team) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (StringUtils.isBlank((String)team.getName())) {
            messages.add(new BetofficeValidationMessage("Name ist nicht gesetzt.", "nickName", BetofficeValidationMessage.Severity.ERROR));
        }
        if (!messages.isEmpty()) {
            throw new BetofficeValidationException(messages);
        }
        this.getConfig().getTeamDao().save(team);
    }

    @Override
    @Transactional
    public TeamAlias createTeamAlias(Team team, String teamAliasName) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (StringUtils.isBlank((String)teamAliasName)) {
            messages.add(new BetofficeValidationMessage("Alias Name nicht gesetzt.", "aliasName", BetofficeValidationMessage.Severity.ERROR));
        }
        TeamAlias teamAlias = null;
        if (!messages.isEmpty()) {
            throw new BetofficeValidationException(messages);
        }
        teamAlias = new TeamAlias();
        teamAlias.setAliasName(teamAliasName);
        teamAlias.setTeam(team);
        this.getConfig().getTeamAliasDao().save(teamAlias);
        return teamAlias;
    }

    @Override
    @Transactional
    public User createUser(User user) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (StringUtils.isBlank((String)user.getNickName())) {
            messages.add(new BetofficeValidationMessage("Nickname ist nicht gesetzt.", "nickName", BetofficeValidationMessage.Severity.ERROR));
        }
        if (!messages.isEmpty()) {
            throw new BetofficeValidationException(messages);
        }
        this.getConfig().getUserDao().save(user);
        return user;
    }

    @Override
    @Transactional
    public void deleteGroupType(GroupType groupType) {
        this.getConfig().getGroupTypeDao().delete(groupType);
    }

    @Override
    @Transactional
    public void deleteTeam(Team team) {
        this.getConfig().getTeamDao().delete(team);
    }

    @Override
    @Transactional
    public void deleteUser(User user) {
        this.getConfig().getUserDao().delete(user);
    }

    @Override
    @Transactional
    public void deleteTeamAlias(TeamAlias teamAlias) {
        this.getConfig().getTeamAliasDao().delete(teamAlias);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GroupType> findAllGroupTypes() {
        return this.getConfig().getGroupTypeDao().findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<User> findUserByNickname(String nickname) {
        return this.getConfig().getUserDao().findByNickname(nickname);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Team> findAllTeams() {
        return this.getConfig().getTeamDao().findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public List<Team> findTeams(TeamType teamType) {
        return this.getConfig().getTeamDao().findTeams(teamType);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeamAlias> findAllTeamAlias(Team team) {
        return this.getConfig().getTeamAliasDao().findAliasNames(team);
    }

    @Override
    @Transactional(readOnly=true)
    public List<User> findAllUsers() {
        return this.getConfig().getUserDao().findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<GroupType> findGroupType(String name) {
        return this.getConfig().getGroupTypeDao().findByName(name);
    }

    @Override
    @Transactional(readOnly=true)
    public GroupType findGroupType(long groupTypeId) {
        return (GroupType)this.getConfig().getGroupTypeDao().findById(groupTypeId);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Team> findTeam(String name) {
        return this.getConfig().getTeamDao().findByName(name);
    }

    @Override
    @Transactional(readOnly=true)
    public Team findTeamById(long id) {
        return (Team)this.getConfig().getTeamDao().findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Team> findTeamByAlias(String aliasName) {
        return this.getConfig().getTeamAliasDao().findByAliasName(aliasName);
    }

    @Override
    @Transactional
    public void updateGroupType(GroupType groupType) {
        this.getConfig().getGroupTypeDao().update(groupType);
    }

    @Override
    @Transactional
    public void updateTeam(Team team) {
        this.getConfig().getTeamDao().update(team);
    }

    @Override
    @Transactional
    public void updateTeamAlias(TeamAlias teamAlias) {
        this.getConfig().getTeamAliasDao().update(teamAlias);
    }

    @Override
    @Transactional
    public void updateUser(User user) {
        this.getConfig().getUserDao().update(user);
    }

    @Override
    @Transactional
    public User findUser(long userId) {
        return (User)this.getConfig().getUserDao().findById(userId);
    }

    @Override
    @Transactional(readOnly=false)
    public Optional<Team> findTeamByOpenligaid(long id) {
        return this.getConfig().getTeamDao().findByOpenligaid(id);
    }

    @Override
    @Transactional
    public void createLocation(Location location) {
        this.getConfig().getLocationDao().save(location);
    }

    @Override
    @Transactional
    public void deleteLocation(Location location) {
        this.getConfig().getLocationDao().delete(location);
    }

    @Override
    @Transactional
    public void updateLocation(Location location) {
        this.getConfig().getLocationDao().update(location);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Location> findAllLocations() {
        return this.getConfig().getLocationDao().findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Location findLocation(long id) {
        return (Location)this.getConfig().getLocationDao().findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Location> findLocationByOpenligaid(long openligaid) {
        return this.getConfig().getLocationDao().findByOpenligaid(openligaid);
    }

    @Override
    @Transactional
    public void createPlayer(Player player) {
        this.getConfig().getPlayerDao().save(player);
    }

    @Override
    @Transactional
    public void deletePlayer(Player player) {
        this.getConfig().getPlayerDao().delete(player);
    }

    @Override
    @Transactional
    public void updatePlayer(Player player) {
        this.getConfig().getPlayerDao().update(player);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Player> findAllPlayers() {
        return this.getConfig().getPlayerDao().findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Player findPlayer(long id) {
        return (Player)this.getConfig().getPlayerDao().findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Player> findPlayerByOpenligaid(long openligaid) {
        return this.getConfig().getPlayerDao().findByOpenligaid(openligaid);
    }
}

