/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.awtools.basic.LoggerFactory;
import de.winkler.betoffice.dao.RoundDao;
import de.winkler.betoffice.service.AbstractManagerService;
import de.winkler.betoffice.service.TippDto;
import de.winkler.betoffice.service.TippService;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.enums.TippStatusType;
import de.winkler.betoffice.storage.exception.StorageObjectNotFoundException;
import de.winkler.betoffice.validation.BetofficeValidationException;
import de.winkler.betoffice.validation.BetofficeValidationMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tippService")
public class DefaultTippService
extends AbstractManagerService
implements TippService {
    private final Logger log = LoggerFactory.make();

    @Override
    @Transactional
    public GameTipp addTipp(String token, Game match, User user, GameResult gr, TippStatusType status) {
        GameTipp gameTipp = match.addTipp(token, user, gr, status);
        this.getConfig().getGameTippDao().save(gameTipp);
        return gameTipp;
    }

    @Override
    @Transactional
    public void addTipp(String token, GameList round, User user, List<GameResult> tipps, TippStatusType status) {
        for (int i = 0; i < round.size(); ++i) {
            this.addTipp(token, round.get(i), user, tipps.get(i), status);
        }
    }

    @Override
    @Transactional
    public void addTipp(TippDto tippDto) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        Optional<User> user = this.getConfig().getUserDao().findByNickname(tippDto.getNickname());
        if (!user.isPresent()) {
            BetofficeValidationMessage msg = new BetofficeValidationMessage("Unknown user with nickname=[" + tippDto.getNickname() + "]", null, BetofficeValidationMessage.Severity.INFO);
            messages.add(msg);
            throw new BetofficeValidationException(messages);
        }
        GameList gameList = (GameList)this.getConfig().getRoundDao().findById(tippDto.getRoundId());
        if (gameList == null) {
            BetofficeValidationMessage msg = new BetofficeValidationMessage("The roundId=[" + tippDto.getRoundId() + "] is invalid.", null, BetofficeValidationMessage.Severity.ERROR);
            messages.add(msg);
            throw new BetofficeValidationException(messages);
        }
        for (TippDto.GameTippDto tipp : tippDto.getGameTipps()) {
            Game game = (Game)this.getConfig().getMatchDao().findById(tipp.getGameId());
            if (game.getDateTime() == null || !tippDto.getSubmitTime().isBefore((ReadableInstant)new DateTime(game.getDateTime().getTime()))) continue;
            GameTipp gameTipp = game.addTipp(tippDto.getToken(), user.get(), new GameResult(tipp.getHomeGoals(), tipp.getGuestGoals()), TippStatusType.USER);
            this.getConfig().getGameTippDao().save(gameTipp);
        }
    }

    @Override
    @Transactional
    public void updateTipp(String token, Game match, User user, GameResult gr, TippStatusType status) {
        this.getConfig().getMatchDao().refresh(match);
        this.addTipp(token, match, user, gr, status);
    }

    @Override
    @Transactional
    public void updateTipp(String token, List<GameTipp> tipps) {
        Date now = DateTime.now().toDate();
        for (GameTipp tipp : tipps) {
            tipp.setLastUpdateTime(now);
            this.getConfig().getGameTippDao().update(tipp);
        }
    }

    @Override
    @Transactional
    public void removeTipp(Game match, User user) {
        try {
            GameTipp gameTipp = match.getGameTipp(user);
            match.removeTipp(gameTipp);
            this.getConfig().getGameTippDao().delete(gameTipp);
        }
        catch (StorageObjectNotFoundException ex) {
            this.log.info("Zu der Spielpaarung " + match + " besitzt der User " + user + " keine Spieltipps.");
            this.log.info("Der L\u00f6schvorgang wurde nicht durchgef\u00fchrt!");
        }
    }

    @Override
    @Transactional
    public List<GameTipp> findTippsByRoundAndUser(GameList round, User user) {
        return this.getConfig().getGameTippDao().findTippsByRoundAndUser(round, user);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GameTipp> findTippsByMatch(Game match) {
        return this.getConfig().getGameTippDao().findByMatch(match);
    }

    @Override
    @Transactional(readOnly=true)
    public GameList findTipp(GameList round, User user) {
        return this.getConfig().getGameTippDao().findRound(round, user);
    }

    @Override
    @Transactional(readOnly=true)
    public GameList findTipp(long roundId, long userId) {
        return this.getConfig().getGameTippDao().findRound(roundId, userId);
    }

    @Override
    @Transactional(readOnly=true)
    public GameList findTippRound(long seasonId, DateTime date) {
        RoundDao roundDao = this.getConfig().getRoundDao();
        Optional<Long> roundId = roundDao.findNextTippRound(seasonId, date);
        if (roundId.isPresent()) {
            return (GameList)roundDao.findById(roundId.get());
        }
        return null;
    }
}

