/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.PlayerDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Player;
import java.util.List;
import java.util.Optional;
import org.hibernate.query.Query;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.springframework.stereotype.Repository;

@Repository(value="playerDao")
public class PlayerDaoHibernate
extends AbstractCommonDao<Player>
implements PlayerDao {
    public PlayerDaoHibernate() {
        super(Player.class);
    }

    @Override
    public List<Player> findAll() {
        return this.getSessionFactory().getCurrentSession().createQuery("from Player as player order by player.name", Player.class).getResultList();
    }

    @Override
    public Optional<Player> findByOpenligaid(long openligaid) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery("from Player as player where player.openligaid = :openligaid", Player.class).setParameter("openligaid", (Object)openligaid, (Type)LongType.INSTANCE);
        return PlayerDaoHibernate.singleResult(query);
    }

    @Override
    public Optional<Player> findAllGoalsOfPlayer(long id) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery("from Player as player left join fetch player.goals where player.id = :id", Player.class).setParameter("id", (Object)id, (Type)LongType.INSTANCE);
        return PlayerDaoHibernate.singleResult(query);
    }
}

