/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.Location;
import de.winkler.betoffice.storage.enums.TeamType;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class Team
extends AbstractStorageObject {
    private static final long serialVersionUID = -3181346057831881080L;
    private Long id;
    public static final String PROPERTY_NAME = "name";
    private String name;
    public static final String PROPERTY_LONGNAME = "longName";
    private String longName;
    public static final String PROPERTY_LOGO = "logo";
    private String logo;
    public static final String PROPERTY_GROUPS = "groups";
    private Set<Group> groups = new HashSet<Group>();
    private TeamType teamType = TeamType.DFB;
    private Location location;
    private Long openligaid;

    public Team() {
    }

    public Team(String value) {
        this(value, null, null);
    }

    public Team(String _name, String _longName, String _logo) {
        this.setName(_name);
        this.setLongName(_longName);
        this.setLogo(_logo);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String value) {
        this.longName = value;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String value) {
        this.logo = value;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    protected void setGroups(Set<Group> value) {
        this.groups = value;
    }

    protected void addGroup(Group value) {
        this.groups.add(value);
    }

    protected void removeGroup(Group value) {
        this.groups.remove(value);
    }

    public TeamType getTeamType() {
        return this.teamType;
    }

    public void setTeamType(TeamType value) {
        this.teamType = value;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location value) {
        this.location = value;
    }

    public Long getOpenligaid() {
        return this.openligaid;
    }

    public void setOpenligaid(Long value) {
        this.openligaid = value;
    }

    public boolean isValid() {
        if (StringUtils.isBlank((String)this.name)) {
            return false;
        }
        if (StringUtils.isBlank((String)this.longName)) {
            return false;
        }
        if (StringUtils.isBlank((String)this.logo)) {
            return false;
        }
        return this.teamType != null;
    }

    public String toString() {
        return this.longName;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Team)) {
            return false;
        }
        Team team = (Team)object;
        return team.getName().equals(this.getName());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getName().hashCode();
        return result;
    }
}

