/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResult;
import de.winkler.betoffice.storage.enums.TippStatusType;
import de.winkler.betoffice.storage.enums.TotoResult;
import java.util.Comparator;
import java.util.Date;

public class GameTipp
extends AbstractStorageObject
implements Comparator<GameTipp> {
    private static final long serialVersionUID = -3043191976453282242L;
    private Long id;
    private GameResult tipp = new GameResult();
    private Date creationTime;
    private Date lastUpdateTime;
    private User user;
    private String token;
    private Game game;
    private TippStatusType status = TippStatusType.UNDEFINED;

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public GameResult getTipp() {
        return this.tipp;
    }

    private void setTipp(GameResult value) {
        this.tipp = value;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date date) {
        this.creationTime = date;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date _lastUpdateTime) {
        this.lastUpdateTime = _lastUpdateTime;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User value) {
        this.user = value;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String _token) {
        this.token = _token;
    }

    public Game getGame() {
        return this.game;
    }

    protected void setGame(Game value) {
        this.game = value;
    }

    public TotoResult getTotoResult() {
        return this.calcTippResult();
    }

    public TippStatusType getStatus() {
        return this.status;
    }

    private void setStatus(TippStatusType value) {
        this.status = value;
    }

    public boolean isInvalid() {
        return TippStatusType.INVALID.equals((Object)this.getStatus());
    }

    public void setTipp(int homeGoals, int guestGoals, TippStatusType theStatus) {
        this.setStatus(theStatus);
        this.setTipp(new GameResult(homeGoals, guestGoals));
    }

    public void setTipp(GameResult _result, TippStatusType _status) {
        this.setStatus(_status);
        this.setTipp(_result);
    }

    public long getPoints() {
        if (this.getTotoResult().equals(TotoResult.EQUAL)) {
            return UserResult.nEqualValue;
        }
        if (this.getTotoResult().equals(TotoResult.TOTO)) {
            return UserResult.nTotoValue;
        }
        if (this.getTotoResult().equals(TotoResult.ZERO)) {
            return UserResult.nZeroValue;
        }
        if (this.getTotoResult().equals(TotoResult.UNDEFINED)) {
            return UserResult.nZeroValue;
        }
        throw new IllegalStateException();
    }

    public double getBeautyPoints() {
        return (double)this.getPoints() / (double)UserResult.nDivisor;
    }

    private TotoResult calcTippResult() {
        if (this.game == null || this.tipp == null) {
            return TotoResult.UNDEFINED;
        }
        if (!this.game.isPlayed()) {
            return TotoResult.UNDEFINED;
        }
        if (this.game.getResult().equals(this.tipp)) {
            return TotoResult.EQUAL;
        }
        if (this.game.getResult().getToto().equals(this.tipp.getToto())) {
            return TotoResult.TOTO;
        }
        return TotoResult.ZERO;
    }

    @Override
    public int compare(GameTipp o1, GameTipp o2) {
        if (o1.getPoints() > o2.getPoints()) {
            return 1;
        }
        if (o1.getPoints() == o2.getPoints()) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        return "GameTipp [id=" + this.id + ", tipp=" + this.tipp + ", creationTime=" + this.creationTime + ", lastUpdateTime=" + this.lastUpdateTime + ", user=" + this.user + ", game=" + this.game + ", status=" + (Object)((Object)this.status) + "]";
    }
}

