/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResult;
import de.winkler.betoffice.storage.enums.TippStatusType;
import org.apache.commons.lang.Validate;

public class UserResultOfDay {
    private boolean isTipped = false;
    private int win = 0;
    private int toto = 0;
    private int tipps = 0;
    private User user;
    private TippStatusType status;

    protected UserResultOfDay() {
    }

    public boolean isValid() {
        return this.user != null;
    }

    public boolean getIsTipped() {
        return this.isTipped;
    }

    public int getWin() {
        return this.win;
    }

    public int getToto() {
        return this.toto;
    }

    public int getTipps() {
        return this.tipps;
    }

    public int getLost() {
        return this.tipps - (this.win + this.toto);
    }

    public User getUser() {
        return this.user;
    }

    public long getPoints() {
        return (long)this.win * UserResult.nEqualValue + (long)this.toto * UserResult.nTotoValue;
    }

    public double getBeautyPoints() {
        return (double)this.getPoints() / (double)UserResult.nDivisor;
    }

    protected void setWin(int value) {
        this.isTipped = true;
        this.win = value;
    }

    protected void setToto(int value) {
        this.isTipped = true;
        this.toto = value;
    }

    protected void setTipps(int value) {
        this.isTipped = true;
        this.tipps = value;
    }

    protected void setUser(User value) {
        Validate.notNull((Object)value);
        this.user = value;
    }

    public final void setStatus(TippStatusType value) {
        Validate.notNull((Object)((Object)value));
        this.status = value;
    }

    public final TippStatusType getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("UROD: ");
        buf.append(this.user);
        buf.append(" Pts: ");
        buf.append(this.getPoints());
        buf.append(" Equal: ");
        buf.append(this.getWin());
        buf.append(" Toto: ");
        buf.append(this.getToto());
        buf.append(" Status: ");
        buf.append(this.getStatus().toString());
        return buf.toString();
    }
}

