/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.GroupDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import java.util.List;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository(value="groupDao")
public class GroupDaoHibernate
extends AbstractCommonDao<Group>
implements GroupDao {
    private static final String QUERY_GROUPS_FROM_SEASON = AbstractCommonDao.loadQuery("hql_groups_season.sql");
    private static final String QUERY_TEAMS_BY_GROUP = AbstractCommonDao.loadQuery("query_teams_group.sql");
    private static final String QUERY_GROUP_BY_SEASON_AND_GROUPTYPE = "select grp from Group as grp inner join grp.season as season inner join grp.groupType as gt where season.id = :seasonId and gt.id = :groupTypeId";

    public GroupDaoHibernate() {
        super(Group.class);
    }

    @Override
    public List<Group> findAll() {
        List groups = this.getSessionFactory().getCurrentSession().createQuery("from group").getResultList();
        return groups;
    }

    @Override
    public List<Group> findBySeason(Season season) {
        List objects = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GROUPS_FROM_SEASON).setParameter("seasonId", (Object)season.getId()).getResultList();
        return objects;
    }

    @Override
    public List<Team> findTeams(Group group) {
        NativeQuery query = this.getSessionFactory().getCurrentSession().createNativeQuery(QUERY_TEAMS_BY_GROUP, Team.class);
        query.setParameter("group_id", (Object)group.getId());
        List teams = query.getResultList();
        return teams;
    }

    @Override
    public Group findBySeasonAndGroupType(Season season, GroupType groupType) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GROUP_BY_SEASON_AND_GROUPTYPE, Group.class);
        query.setParameter("seasonId", (Object)season.getId());
        query.setParameter("groupTypeId", (Object)groupType.getId());
        return (Group)query.getSingleResult();
    }
}

