/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.UserDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResult;
import de.winkler.betoffice.storage.comparator.UserPointsComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.stereotype.Repository;

@Repository(value="userDao")
public class UserDaoHibernate
extends AbstractCommonDao<User>
implements UserDao {
    private static final String QUERY_USER_BY_NICKNAME = "from " + User.class.getName() + " as user where user.nickName = :nickName";
    private static final String QUERY_SEASON_13_POINTS = AbstractCommonDao.loadQuery("query_userresult_season_13.sql");
    private static final String QUERY_SEASON_10_POINTS = AbstractCommonDao.loadQuery("query_userresult_season_10.sql");
    private static final String QUERY_SEASON_RANGE_13_POINTS = AbstractCommonDao.loadQuery("query_userresult_season_range_13.sql");
    private static final String QUERY_SEASON_RANGE_10_POINTS = AbstractCommonDao.loadQuery("query_userresult_season_range_10.sql");
    private static final String QUERY_SEASON_RANGE_COUNT_MATCHES = AbstractCommonDao.loadQuery("query_countmatches_season_range.sql");
    private static final String QUERY_SEASON_COUNT_MATCHES = AbstractCommonDao.loadQuery("query_countmatches_season.sql");

    public UserDaoHibernate() {
        super(User.class);
    }

    @Override
    public List<User> findAll() {
        List users = this.getSessionFactory().getCurrentSession().createQuery("from User order by nickName", User.class).getResultList();
        return users;
    }

    @Override
    public Optional<User> findByNickname(String nickname) {
        Query user = this.getSessionFactory().getCurrentSession().createQuery(QUERY_USER_BY_NICKNAME, User.class).setParameter("nickName", (Object)nickname);
        return UserDaoHibernate.singleResult(user);
    }

    @Override
    public List<UserResult> calculateUserRanking(List<User> users, Season season, int startIndex, int endIndex) {
        HashMap<User, UserResult> resultMap = new HashMap<User, UserResult>();
        for (User user : users) {
            resultMap.put(user, new UserResult(user));
        }
        NativeQuery query13 = this.getSessionFactory().getCurrentSession().createSQLQuery(QUERY_SEASON_RANGE_13_POINTS).addEntity("user", User.class).addScalar("full_points", (Type)StandardBasicTypes.LONG);
        query13.setParameter("season_id", (Object)season.getId());
        query13.setParameter("start_index", (Object)startIndex);
        query13.setParameter("end_index", (Object)endIndex);
        List resultQuery13 = query13.list();
        for (Object object : resultQuery13) {
            Object[] row = (Object[])object;
            User user = (User)row[0];
            int fullPoints = ((Long)row[1]).intValue();
            if (resultMap.containsKey(user)) {
                ((UserResult)resultMap.get(user)).setUserWin(fullPoints);
                continue;
            }
            UserResult ur = new UserResult(user);
            ur.setUserWin(fullPoints);
            resultMap.put(user, ur);
        }
        NativeQuery query10 = this.getSessionFactory().getCurrentSession().createNativeQuery(QUERY_SEASON_RANGE_10_POINTS).addEntity("user", User.class).addScalar("half_points", (Type)StandardBasicTypes.LONG);
        query10.setParameter("season_id", (Object)season.getId());
        query10.setParameter("start_index", (Object)startIndex);
        query10.setParameter("end_index", (Object)endIndex);
        List resultQuery10 = query10.list();
        for (Object object : resultQuery10) {
            Object[] row = (Object[])object;
            User user = (User)row[0];
            int halfPoints = ((Long)row[1]).intValue();
            if (resultMap.containsKey(user)) {
                ((UserResult)resultMap.get(user)).setUserTotoWin(halfPoints);
                continue;
            }
            UserResult ur = new UserResult(user);
            ur.setUserTotoWin(halfPoints);
            resultMap.put(user, ur);
        }
        NativeQuery queryMatches = this.getSessionFactory().getCurrentSession().createNativeQuery(QUERY_SEASON_RANGE_COUNT_MATCHES).addScalar("count_matches", (Type)StandardBasicTypes.LONG);
        queryMatches.setParameter("season_id", (Object)season.getId());
        queryMatches.setParameter("start_index", (Object)startIndex);
        queryMatches.setParameter("end_index", (Object)endIndex);
        Long countMatches = (Long)queryMatches.uniqueResult();
        return this.userResultMapToList(resultMap, countMatches.intValue());
    }

    @Override
    public List<UserResult> calculateUserRanking(List<User> users, GameList round) {
        return this.calculateUserRanking(users, round.getSeason(), round.getIndex(), round.getIndex());
    }

    @Override
    public List<UserResult> calculateUserRanking(List<User> users, Season season) {
        HashMap<User, UserResult> resultMap = new HashMap<User, UserResult>();
        for (User user : users) {
            resultMap.put(user, new UserResult(user));
        }
        NativeQuery query13 = this.getSessionFactory().getCurrentSession().createNativeQuery(QUERY_SEASON_13_POINTS).addEntity("user", User.class).addScalar("full_points", (Type)StandardBasicTypes.LONG);
        query13.setParameter("season_id", (Object)season.getId());
        List resultQuery13 = query13.list();
        for (Object object : resultQuery13) {
            Object[] row = (Object[])object;
            User user = (User)row[0];
            int fullPoints = ((Long)row[1]).intValue();
            if (resultMap.containsKey(user)) {
                ((UserResult)resultMap.get(user)).setUserWin(fullPoints);
                continue;
            }
            UserResult ur = new UserResult(user);
            ur.setUserWin(fullPoints);
            resultMap.put(user, ur);
        }
        NativeQuery query10 = this.getSessionFactory().getCurrentSession().createNativeQuery(QUERY_SEASON_10_POINTS).addEntity("user", User.class).addScalar("half_points", (Type)StandardBasicTypes.LONG);
        query10.setParameter("season_id", (Object)season.getId());
        List resultQuery10 = query10.list();
        for (Object object : resultQuery10) {
            Object[] row = (Object[])object;
            User user = (User)row[0];
            int halfPoints = ((Long)row[1]).intValue();
            if (resultMap.containsKey(user)) {
                ((UserResult)resultMap.get(user)).setUserTotoWin(halfPoints);
                continue;
            }
            UserResult ur = new UserResult(user);
            ur.setUserTotoWin(halfPoints);
            resultMap.put(user, ur);
        }
        NativeQuery queryMatches = this.getSessionFactory().getCurrentSession().createNativeQuery(QUERY_SEASON_COUNT_MATCHES).addScalar("count_matches", (Type)StandardBasicTypes.LONG);
        queryMatches.setParameter("season_id", (Object)season.getId());
        Long countMatches = (Long)queryMatches.uniqueResult();
        return this.userResultMapToList(resultMap, countMatches.intValue());
    }

    private List<UserResult> userResultMapToList(Map<User, UserResult> resultMap, int countMatches) {
        ArrayList<UserResult> userResults = new ArrayList<UserResult>();
        userResults.addAll(resultMap.values());
        Collections.sort(userResults, new UserPointsComparator());
        int tabpos = 1;
        for (UserResult userResult : userResults) {
            userResult.setTicket(countMatches - userResult.getUserTotoWin() - userResult.getUserWin());
            userResult.setTabPos(tabpos);
            ++tabpos;
        }
        return userResults;
    }
}

