/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.tippengine;

import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResultOfDay;
import de.winkler.betoffice.storage.enums.TippStatusType;
import de.winkler.betoffice.storage.exception.StorageObjectNotFoundException;
import de.winkler.betoffice.tippengine.InfoCenter;
import de.winkler.betoffice.tippengine.TippGenerator;
import de.winkler.betoffice.util.LoggerFactory;
import java.util.List;
import org.slf4j.Logger;

public class MinTippGenerator
implements TippGenerator {
    private final String BOT_MIN_TIPP = "#BOT_MIN_TIPP#";
    private final Logger log = LoggerFactory.make();

    @Override
    public void generateTipp(Season season) {
        for (int i = 0; i < season.toGameList().size(); ++i) {
            this.generateTipp(season.getGamesOfDay(i));
        }
    }

    @Override
    public void generateTipp(GameList round) {
        List<User> users = round.getSeason().getUsers();
        for (User user : users) {
            if (user.isExcluded() || user.isAutomat()) continue;
            this.generateTipp(round, user, users);
        }
    }

    private void generateTipp(GameList round, User user, List<User> users) {
        UserResultOfDay minUser = InfoCenter.getMinTipp(round, users);
        if (this.log.isDebugEnabled()) {
            this.log.debug(new StringBuffer("Min-Tipp von User: ").append(minUser).toString());
        }
        List<Game> games = round.unmodifiableList();
        for (Game game : games) {
            block14: {
                if (this.log.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(">>> Generiere Tipp f\u00fcr User: ");
                    buf.append(user);
                    buf.append(" f\u00fcr Spiel: ");
                    buf.append(game);
                    this.log.debug(buf.toString());
                }
                GameResult minTippResult = null;
                try {
                    if (minUser == null) {
                        minTippResult = new GameResult(0, 0);
                    } else {
                        GameTipp minTipp = game.getGameTipp(minUser.getUser());
                        minTippResult = minTipp.getTipp();
                    }
                }
                catch (StorageObjectNotFoundException ex) {
                    this.log.info("Kein MinTipp vorhanden.");
                    minTippResult = new GameResult(0, 0);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Ermittelter Min-Tipp: " + minTippResult);
                }
                try {
                    GameTipp tipp = game.getGameTipp(user);
                    if (tipp.getStatus() == TippStatusType.MIN || tipp.getStatus() == TippStatusType.UNDEFINED || tipp.getStatus() == TippStatusType.INVALID) {
                        tipp.setTipp(minTippResult, TippStatusType.MIN);
                        break block14;
                    }
                    if (tipp.getStatus() == TippStatusType.AUTO || tipp.getStatus() == TippStatusType.USER) {
                        this.log.debug("Tipp wird nicht \u00fcberschrieben.");
                        break block14;
                    }
                    throw new IllegalStateException("GameTippStatus " + (Object)((Object)tipp.getStatus()) + " nicht vorgesehen.");
                }
                catch (StorageObjectNotFoundException ex) {
                    game.addTipp("#BOT_MIN_TIPP#", user, minTippResult, TippStatusType.MIN);
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            StringBuilder buf = new StringBuilder();
            buf.append("User: ");
            buf.append(user);
            buf.append(" Min-Tipp: ");
            try {
                buf.append(game.getGameTipp(user));
            }
            catch (StorageObjectNotFoundException ex) {
                buf.append("Kein Tipp vorhanden.");
            }
            this.log.debug(buf.toString());
        }
    }
}

