/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.GameTippDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.User;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository(value="gameTippDao")
public class GameTippDaoHibernate
extends AbstractCommonDao<GameTipp>
implements GameTippDao {
    private static final String QUERY_GAMETIPP_BY_MATCH = "from     GameTipp gametipp inner join fetch     gametipp.user inner join fetch     gametipp.game where     gametipp.game.id = :gameId";
    private static final String QUERY_GAMETIPP_BY_SEASON_ROUND_AND_USER = AbstractCommonDao.loadQuery("hql_gametipp_season_round_user.sql");
    private static final String QUERY_ROUND_GAME_TIPP_AND_USER = AbstractCommonDao.loadQuery("hql_round_game_tipp_user.sql");
    private static final String QUERY_ROUND_GAME_TIPP = AbstractCommonDao.loadQuery("hql_round_game_tipp.sql");

    public GameTippDaoHibernate() {
        super(GameTipp.class);
    }

    @Override
    public List<GameTipp> findByMatch(Game match) {
        List tipps = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMETIPP_BY_MATCH, GameTipp.class).setParameter("gameId", (Object)match.getId()).getResultList();
        return tipps;
    }

    @Override
    public List<GameTipp> findTippsByRoundAndUser(GameList round, User user) {
        return this.findTippsByRoundAndUser(round.getId(), user);
    }

    @Override
    public List<GameTipp> findTippsByRoundAndUser(long roundId, User user) {
        List objects = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMETIPP_BY_SEASON_ROUND_AND_USER, GameTipp.class).setParameter("roundId", (Object)roundId).setParameter("userId", (Object)user.getId()).getResultList();
        return objects;
    }

    @Override
    public GameList findRound(GameList round, User user) {
        return this.findRound(round.getId(), user.getId());
    }

    @Override
    public GameList findRound(long roundId, long userId) {
        List rounds = this.getSessionFactory().getCurrentSession().createQuery(QUERY_ROUND_GAME_TIPP_AND_USER, GameList.class).setParameter("roundId", (Object)roundId).setParameter("userId", (Object)userId).getResultList();
        if (rounds.isEmpty()) {
            return null;
        }
        return (GameList)rounds.get(0);
    }

    @Override
    public GameList findRound(long roundId) {
        List rounds = this.getSessionFactory().getCurrentSession().createQuery(QUERY_ROUND_GAME_TIPP, GameList.class).setParameter("roundId", (Object)roundId).getResultList();
        if (rounds.isEmpty()) {
            return null;
        }
        return (GameList)rounds.get(0);
    }
}

