/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.tippengine;

import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.enums.TippStatusType;
import de.winkler.betoffice.tippengine.InfoCenter;
import de.winkler.betoffice.tippengine.TippGenerator;
import java.util.List;
import java.util.ListIterator;

public class MediumTippGenerator
implements TippGenerator {
    private final String BOT_MEDIUM_TIPP = "#BOT_MEDIUM_TIPP#";
    private final User user;

    public MediumTippGenerator(User _user) {
        this.user = _user;
    }

    @Override
    public void generateTipp(Season season) {
        List<GameList> gameDays = season.toGameList();
        ListIterator<GameList> i = gameDays.listIterator();
        while (i.hasNext()) {
            this.generateTipp((GameList)i.next());
        }
    }

    @Override
    public void generateTipp(GameList round) {
        List<Game> games = round.unmodifiableList();
        for (Game game : games) {
            GameResult gr = InfoCenter.getMediumTipp(game);
            if (gr == null) continue;
            game.addTipp("#BOT_MEDIUM_TIPP#", this.user, gr, TippStatusType.AUTO);
        }
    }
}

