/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.dao.GroupTypeDao;
import de.winkler.betoffice.dao.LocationDao;
import de.winkler.betoffice.dao.PlayerDao;
import de.winkler.betoffice.dao.SeasonDao;
import de.winkler.betoffice.dao.TeamAliasDao;
import de.winkler.betoffice.dao.TeamDao;
import de.winkler.betoffice.dao.UserDao;
import de.winkler.betoffice.service.AbstractManagerService;
import de.winkler.betoffice.service.MasterDataManagerService;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Location;
import de.winkler.betoffice.storage.Player;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.TeamAlias;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.enums.TeamType;
import de.winkler.betoffice.validation.BetofficeValidationException;
import de.winkler.betoffice.validation.BetofficeValidationMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="masterDataManagerService")
public class DefaultMasterDataManagerService
extends AbstractManagerService
implements MasterDataManagerService {
    @Autowired
    private SeasonDao seasonDao;
    @Autowired
    private GroupTypeDao groupTypeDao;
    @Autowired
    private TeamDao teamDao;
    @Autowired
    private TeamAliasDao teamAliasDao;
    @Autowired
    private LocationDao locationDao;
    @Autowired
    private PlayerDao playerDao;
    @Autowired
    private UserDao userDao;

    @Override
    @Transactional
    public void createSeason(Season season) {
        this.seasonDao.save(season);
    }

    @Override
    @Transactional
    public void updateSeason(Season season) {
        this.seasonDao.update(season);
    }

    @Override
    @Transactional
    public void createGroupType(GroupType groupType) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (StringUtils.isBlank((CharSequence)groupType.getName())) {
            messages.add(new BetofficeValidationMessage("Name ist nicht gesetzt.", "nickName", BetofficeValidationMessage.Severity.ERROR));
        }
        if (!messages.isEmpty()) {
            throw new BetofficeValidationException(messages);
        }
        this.groupTypeDao.save(groupType);
    }

    @Override
    @Transactional
    public void createTeam(Team team) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (StringUtils.isBlank((CharSequence)team.getName())) {
            messages.add(new BetofficeValidationMessage("Name ist nicht gesetzt.", "nickName", BetofficeValidationMessage.Severity.ERROR));
        }
        if (!messages.isEmpty()) {
            throw new BetofficeValidationException(messages);
        }
        this.teamDao.save(team);
    }

    @Override
    @Transactional
    public TeamAlias createTeamAlias(Team team, String teamAliasName) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (StringUtils.isBlank((CharSequence)teamAliasName)) {
            messages.add(new BetofficeValidationMessage("Alias Name nicht gesetzt.", "aliasName", BetofficeValidationMessage.Severity.ERROR));
        }
        TeamAlias teamAlias = null;
        if (!messages.isEmpty()) {
            throw new BetofficeValidationException(messages);
        }
        teamAlias = new TeamAlias();
        teamAlias.setAliasName(teamAliasName);
        teamAlias.setTeam(team);
        this.teamAliasDao.save(teamAlias);
        return teamAlias;
    }

    @Override
    @Transactional
    public User createUser(User user) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (StringUtils.isBlank((CharSequence)user.getNickName())) {
            messages.add(new BetofficeValidationMessage("Nickname ist nicht gesetzt.", "nickName", BetofficeValidationMessage.Severity.ERROR));
        }
        if (!messages.isEmpty()) {
            throw new BetofficeValidationException(messages);
        }
        this.userDao.save(user);
        return user;
    }

    @Override
    @Transactional
    public void deleteGroupType(GroupType groupType) {
        this.groupTypeDao.delete(groupType);
    }

    @Override
    @Transactional
    public void deleteTeam(Team team) {
        this.teamDao.delete(team);
    }

    @Override
    @Transactional
    public void deleteUser(User user) {
        this.userDao.delete(user);
    }

    @Override
    @Transactional
    public void deleteTeamAlias(TeamAlias teamAlias) {
        this.teamAliasDao.delete(teamAlias);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GroupType> findAllGroupTypes() {
        return this.groupTypeDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<User> findUserByNickname(String nickname) {
        return this.userDao.findByNickname(nickname);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Team> findAllTeams() {
        return this.teamDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public List<Team> findTeams(TeamType teamType) {
        return this.teamDao.findTeams(teamType);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeamAlias> findAllTeamAlias(Team team) {
        return this.teamAliasDao.findAliasNames(team);
    }

    @Override
    @Transactional(readOnly=true)
    public List<User> findAllUsers() {
        return this.userDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<GroupType> findGroupType(String name) {
        return this.groupTypeDao.findByName(name);
    }

    @Override
    @Transactional(readOnly=true)
    public GroupType findGroupType(long groupTypeId) {
        return (GroupType)this.groupTypeDao.findById(groupTypeId);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Team> findTeam(String name) {
        return this.teamDao.findByName(name);
    }

    @Override
    @Transactional(readOnly=true)
    public Team findTeamById(long id) {
        return (Team)this.teamDao.findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Team> findTeamByAlias(String aliasName) {
        return this.teamAliasDao.findByAliasName(aliasName);
    }

    @Override
    @Transactional
    public void updateGroupType(GroupType groupType) {
        this.groupTypeDao.update(groupType);
    }

    @Override
    @Transactional
    public void updateTeam(Team team) {
        this.teamDao.update(team);
    }

    @Override
    @Transactional
    public void updateTeamAlias(TeamAlias teamAlias) {
        this.teamAliasDao.update(teamAlias);
    }

    @Override
    @Transactional
    public void updateUser(User user) {
        this.userDao.update(user);
    }

    @Override
    @Transactional
    public User findUser(long userId) {
        return (User)this.userDao.findById(userId);
    }

    @Override
    @Transactional(readOnly=false)
    public Optional<Team> findTeamByOpenligaid(long id) {
        return this.teamDao.findByOpenligaid(id);
    }

    @Override
    @Transactional
    public void createLocation(Location location) {
        this.locationDao.save(location);
    }

    @Override
    @Transactional
    public void deleteLocation(Location location) {
        this.locationDao.delete(location);
    }

    @Override
    @Transactional
    public void updateLocation(Location location) {
        this.locationDao.update(location);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Location> findAllLocations() {
        return this.locationDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Location findLocation(long id) {
        return (Location)this.locationDao.findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Location> findLocationByOpenligaid(long openligaid) {
        return this.locationDao.findByOpenligaid(openligaid);
    }

    @Override
    @Transactional
    public void createPlayer(Player player) {
        this.playerDao.save(player);
    }

    @Override
    @Transactional
    public void deletePlayer(Player player) {
        this.playerDao.delete(player);
    }

    @Override
    @Transactional
    public void updatePlayer(Player player) {
        this.playerDao.update(player);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Player> findAllPlayers() {
        return this.playerDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public Player findPlayer(long id) {
        return (Player)this.playerDao.findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Player> findPlayerByOpenligaid(long openligaid) {
        return this.playerDao.findByOpenligaid(openligaid);
    }
}

