/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.Goal;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.Location;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.enums.TippStatusType;
import de.winkler.betoffice.storage.exception.StorageObjectExistsException;
import de.winkler.betoffice.storage.exception.StorageObjectNotFoundException;
import de.winkler.betoffice.storage.exception.StorageObjectNotValidException;
import de.winkler.betoffice.storage.exception.StorageRuntimeException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;

@Entity
@Table(name="bo_game")
public class Game
extends AbstractStorageObject
implements Comparable<Game> {
    private static final long serialVersionUID = 8861153553430553696L;
    private static Log log = LogFactory.getLog(Game.class);
    public static final String EMPTY = "";
    public static final int WIN = 3;
    public static final int LOST = 0;
    public static final int REMIS = 1;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Column(name="bo_datetime")
    private Date dateTime;
    @ManyToOne
    @JoinColumn(name="bo_group_ref")
    private Group group;
    @ManyToOne
    @JoinColumn(name="bo_hometeam_ref")
    private Team homeTeam;
    @ManyToOne
    @JoinColumn(name="bo_guestteam_ref")
    private Team guestTeam;
    @Column(name="bo_isplayed")
    private boolean played = false;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(column=@Column(name="bo_homegoals"), name="homeGoals"), @AttributeOverride(column=@Column(name="bo_guestgoals"), name="guestGoals")})
    private GameResult result = new GameResult();
    @AttributeOverrides(value={@AttributeOverride(column=@Column(name="bo_halftimehomegoals"), name="homeGoals"), @AttributeOverride(column=@Column(name="bo_halftimeguestgoals"), name="guestGoals")})
    private GameResult halfTimeGoals = new GameResult();
    @AttributeOverrides(value={@AttributeOverride(column=@Column(name="bo_overtimehomegoals"), name="homeGoals"), @AttributeOverride(column=@Column(name="bo_overtimeguestgoals"), name="guestGoals")})
    private GameResult overTimeGoals = new GameResult();
    @AttributeOverrides(value={@AttributeOverride(column=@Column(name="bo_penaltyhomegoals"), name="homeGoals"), @AttributeOverride(column=@Column(name="bo_penaltyguestgoals"), name="guestGoals")})
    private GameResult penaltyGoals = new GameResult();
    @ManyToOne
    @JoinColumn(name="bo_location_ref")
    private Location location;
    @Column(name="bo_index")
    private int index;
    @ManyToOne
    @JoinColumn(name="bo_gamelist_ref")
    private GameList gameList;
    @OneToMany(mappedBy="game", cascade={CascadeType.ALL})
    @OrderBy(value="bo_index")
    private List<Goal> goals = new ArrayList<Goal>();
    @OneToMany(mappedBy="game")
    private Set<GameTipp> tippList = new HashSet<GameTipp>();
    @Column(name="bo_openligaid")
    private Long openligaid;
    @Column(name="bo_ko")
    private boolean ko = false;

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public Date getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(Date _dateTime) {
        this.dateTime = _dateTime;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group value) {
        this.group = value;
    }

    public Team getHomeTeam() {
        return this.homeTeam;
    }

    public void setHomeTeam(Team value) {
        this.homeTeam = value;
    }

    public Team getGuestTeam() {
        return this.guestTeam;
    }

    public void setGuestTeam(Team value) {
        this.guestTeam = value;
    }

    public GameResult getResult() {
        return this.result;
    }

    public void setResult(GameResult value) {
        this.result = value;
    }

    public void setResult(int homeGoals, int guestGoals) {
        this.setResult(new GameResult(homeGoals, guestGoals));
    }

    public void setResult(int homeGoals, int guestGoals, boolean finished) {
        GameResult newValue = new GameResult(homeGoals, guestGoals);
        this.setResult(newValue);
        this.setPlayed(finished);
    }

    public GameResult getHalfTimeGoals() {
        return this.halfTimeGoals;
    }

    public void setHalfTimeGoals(GameResult _halfTimeGoals) {
        this.halfTimeGoals = _halfTimeGoals;
    }

    public void setHalfTimeGoals(int homeGoals, int guestGoals) {
        this.setHalfTimeGoals(new GameResult(homeGoals, guestGoals));
    }

    public GameResult getOverTimeGoals() {
        return this.overTimeGoals;
    }

    public void setOverTimeGoals(GameResult _overTimeGoals) {
        this.overTimeGoals = _overTimeGoals;
    }

    public void setOverTimeGoals(int homeGoals, int guestGoals) {
        this.setOverTimeGoals(new GameResult(homeGoals, guestGoals));
    }

    public GameResult getPenaltyGoals() {
        return this.penaltyGoals;
    }

    public void setPenaltyGoals(GameResult _penaltyGoals) {
        this.penaltyGoals = _penaltyGoals;
    }

    public void setPenaltyGoals(int homeGoals, int guestGoals) {
        this.setPenaltyGoals(new GameResult(homeGoals, guestGoals));
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location _location) {
        this.location = _location;
    }

    public boolean isPlayed() {
        return this.played;
    }

    public void setPlayed(boolean value) {
        this.played = value;
    }

    public GameList getGameList() {
        return this.gameList;
    }

    protected void setGameList(GameList value) {
        this.gameList = value;
    }

    public int getIndex() {
        if (this.getGameList() == null) {
            return -1;
        }
        if (!this.getGameList().getGameList().contains(this)) {
            return -1;
        }
        return this.getGameList().getGameList().indexOf(this);
    }

    public void setIndex(int value) {
    }

    public List<Goal> getGoals() {
        return this.goals;
    }

    protected void setGoals(List<Goal> _goals) {
        this.goals = _goals;
    }

    public void addGoal(Goal goal) {
        this.goals.add(goal);
    }

    public List<Goal> removeAllGoals() {
        ArrayList<Goal> removedGoals = new ArrayList<Goal>();
        for (Goal goal : this.goals) {
            goal.getPlayer().getGoals().remove(goal);
            removedGoals.add(goal);
        }
        this.goals.clear();
        return removedGoals;
    }

    protected Set<GameTipp> getTippList() {
        return this.tippList;
    }

    protected void setTippList(Set<GameTipp> value) {
        this.tippList = value;
    }

    public Long getOpenligaid() {
        return this.openligaid;
    }

    public void setOpenligaid(Long value) {
        this.openligaid = value;
    }

    public boolean isKo() {
        return this.ko;
    }

    public void setKo(boolean value) {
        this.ko = value;
    }

    public GameTipp addTipp(String token, User user, GameResult gr, TippStatusType status) {
        Validate.notNull((Object)token);
        Validate.notNull((Object)user);
        Validate.notNull((Object)gr);
        Validate.notNull((Object)((Object)status));
        GameTipp tipp = null;
        if (this.containsTipp(user)) {
            try {
                tipp = this.getGameTipp(user);
                tipp.setToken(token);
                tipp.setTipp(gr, status);
                tipp.setLastUpdateTime(DateTime.now().toDate());
            }
            catch (StorageObjectNotFoundException ex) {
                log.error((Object)"storage object not found exception", (Throwable)ex);
                throw new StorageRuntimeException(ex);
            }
        }
        tipp = new GameTipp();
        tipp.setToken(token);
        tipp.setUser(user);
        tipp.setGame(this);
        tipp.setTipp(gr, status);
        Date now = DateTime.now().toDate();
        tipp.setLastUpdateTime(now);
        tipp.setCreationTime(now);
        try {
            this.addTipp(tipp);
        }
        catch (StorageObjectExistsException ex) {
            log.error((Object)"storage object exists exception", (Throwable)ex);
            throw new StorageRuntimeException(ex);
        }
        catch (StorageObjectNotValidException ex) {
            log.error((Object)"storage object not valid exception", (Throwable)ex);
            throw new StorageRuntimeException(ex);
        }
        return tipp;
    }

    public void addTipp(GameTipp tipp) throws StorageObjectExistsException {
        Validate.notNull((Object)tipp);
        if (this.containsTipp(tipp.getUser())) {
            StringBuilder buf = new StringBuilder("'");
            buf.append(tipp.toString()).append("' already exists!");
            log.error((Object)buf);
            throw new StorageObjectExistsException(buf.toString());
        }
        if (tipp.getGame() != this) {
            StringBuilder buf = new StringBuilder("'");
            buf.append(tipp.toString()).append("' game property failure!");
            log.error((Object)buf);
            throw new IllegalArgumentException(buf.toString());
        }
        tipp.setGame(this);
        this.tippList.add(tipp);
    }

    public void removeAllTipp() {
        ArrayList<GameTipp> tmp = new ArrayList<GameTipp>(this.getTippList());
        for (GameTipp tipp : tmp) {
            try {
                this.removeTipp(tipp);
            }
            catch (StorageObjectNotFoundException ex) {
                log.fatal((Object)"Error", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public void removeTipp(GameTipp tipp) throws StorageObjectNotFoundException {
        Validate.notNull((Object)tipp, (String)"tipp als null-Parameter", (Object[])new Object[0]);
        if (!this.containsTipp(tipp.getUser())) {
            StringBuffer buf = new StringBuffer();
            buf.append(tipp.toString());
            buf.append(" nicht vorhanden.");
            log.error((Object)buf);
            throw new StorageObjectNotFoundException(buf.toString());
        }
        this.tippList.remove(tipp);
        tipp.setGame(null);
    }

    public GameTipp getGameTipp(User user) throws StorageObjectNotFoundException {
        Validate.notNull((Object)user, (String)"user als null Parameter", (Object[])new Object[0]);
        Optional<GameTipp> userTipp = this.tippList.stream().filter(tipp -> tipp != null && tipp.getUser().equals(user)).findFirst();
        if (userTipp.isPresent()) {
            return userTipp.get();
        }
        throw new StorageObjectNotFoundException("Der Teilnehmer [" + user.getNickName() + "] hat keinen Spieltipp.");
    }

    public GameTipp getGameTippOrInvalid(User user) {
        GameTipp gameTipp = null;
        try {
            gameTipp = this.getGameTipp(user);
        }
        catch (StorageObjectNotFoundException ex) {
            gameTipp = new GameTipp();
            gameTipp.setGame(this);
            gameTipp.setUser(user);
            gameTipp.setTipp(0, 0, TippStatusType.INVALID);
        }
        return gameTipp;
    }

    public boolean containsTipp(User user) {
        return this.tippList.stream().anyMatch(tipp -> tipp.getUser().equals(user));
    }

    public int tippSize() {
        return this.tippList.size();
    }

    public Set<GameTipp> getTipps() {
        return this.tippList;
    }

    @Override
    public int compareTo(Game _game) {
        if (this.getIndex() < _game.getIndex()) {
            return -1;
        }
        if (this.getIndex() > _game.getIndex()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.getDateTime() == null) {
            buf.append("Date: <null>");
        } else {
            buf.append("Date: ");
            buf.append(this.getDateTime());
        }
        buf.append("; ");
        if (this.getGroup() == null) {
            buf.append("Group: <null>");
        } else {
            buf.append(this.getGroup());
        }
        buf.append("; ");
        if (this.homeTeam == null) {
            buf.append("HTeam: <null>");
        } else {
            buf.append(this.homeTeam.getName());
        }
        buf.append(':');
        if (this.guestTeam == null) {
            buf.append("GTeam: <null>");
        } else {
            buf.append(this.guestTeam.getName());
        }
        buf.append("; ");
        buf.append(this.result);
        return buf.toString();
    }
}

