/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.tippengine;

import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResultOfDay;
import de.winkler.betoffice.storage.enums.TippStatusType;
import java.util.List;
import org.apache.commons.lang3.Validate;

public final class InfoCenter {
    protected InfoCenter() {
    }

    public static User getMaxTipp(GameList gamelist, List<User> users) {
        Validate.notNull((Object)gamelist);
        Validate.notNull(users);
        UserResultOfDay max = null;
        for (User user : users) {
            if (user.isExcluded()) continue;
            UserResultOfDay urod = gamelist.getUserPoints(user);
            if (max == null) {
                max = urod;
                continue;
            }
            if (urod.getPoints() <= max.getPoints()) continue;
            max = urod;
        }
        return max.getUser();
    }

    public static UserResultOfDay getMinTipp(GameList gamelist, List<User> users) {
        Validate.notNull((Object)gamelist);
        Validate.notNull(users);
        UserResultOfDay min = null;
        for (User user : users) {
            UserResultOfDay urod;
            if (user.isExcluded() || !TippStatusType.USER.equals((Object)(urod = gamelist.getUserPoints(user)).getStatus())) continue;
            if (min == null) {
                min = urod;
                continue;
            }
            if (!urod.getIsTipped() || urod.getPoints() >= min.getPoints()) continue;
            min = urod;
        }
        return min;
    }

    public static GameResult getMediumTipp(Game game) {
        Validate.notNull((Object)game, (String)"game ist null", (Object[])new Object[0]);
        int homeGoals = 0;
        int guestGoals = 0;
        int counter = 0;
        for (GameTipp tipp : game.getTipps()) {
            if (!TippStatusType.USER.equals((Object)tipp.getStatus())) continue;
            ++counter;
            homeGoals += tipp.getTipp().getHomeGoals();
            guestGoals += tipp.getTipp().getGuestGoals();
        }
        if (counter != 0) {
            return new GameResult(Math.round(homeGoals / counter), Math.round(guestGoals / counter));
        }
        return null;
    }
}

