/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.dao.CommunityDao;
import de.winkler.betoffice.dao.UserDao;
import de.winkler.betoffice.service.AbstractManagerService;
import de.winkler.betoffice.service.CommunityService;
import de.winkler.betoffice.storage.Community;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.util.LoggerFactory;
import java.util.List;
import javax.persistence.NoResultException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="communityService")
public class DefaultCommunityService
extends AbstractManagerService
implements CommunityService {
    private static final Logger LOG = LoggerFactory.make();
    @Autowired
    private CommunityDao communityDao;
    @Autowired
    private UserDao userDao;

    @Override
    public Community find(String communityName) {
        return this.communityDao.find(communityName);
    }

    @Override
    public List<Community> findAll(String communityNameFilter) {
        return this.communityDao.findAll(communityNameFilter);
    }

    @Override
    public Community findCommunityMembers(String communityName) {
        return this.communityDao.findCommunityMembers(communityName);
    }

    @Override
    public Community create(String communityName, String managerNickname) {
        this.validateCommunityName(communityName);
        try {
            this.communityDao.find(communityName);
            throw new IllegalArgumentException("Community '" + communityName + "' is already defined.");
        }
        catch (NoResultException noResultException) {
            this.validateNickname(managerNickname);
            User communityManager = this.findUser(managerNickname);
            Community community = new Community();
            community.setName(communityName);
            community.setCommunityManager(communityManager);
            return this.communityDao.save(community);
        }
    }

    @Override
    public void delete(String communityName) {
        Community community = null;
        try {
            community = this.communityDao.find(communityName);
        }
        catch (NoResultException ex) {
            throw new IllegalArgumentException("Unknwon community name '" + communityName + "'.");
        }
        if (this.communityDao.hasMembers(community)) {
            LOG.warn("Unable to delete community '{}'. The Community has members.", (Object)community);
            throw new IllegalArgumentException("Unable to delete community. The Community has members.");
        }
        this.communityDao.delete(community);
    }

    @Override
    public Community addMember(String communityName, String nickname) {
        this.validateCommunityName(communityName);
        this.validateNickname(nickname);
        User user = this.findUser(nickname);
        try {
            Community community = this.communityDao.findCommunityMembers(communityName);
            community.addMember(user);
            this.communityDao.save(community);
            return community;
        }
        catch (NoResultException ex) {
            throw new IllegalArgumentException("Unknwon community name '" + communityName + "'.");
        }
    }

    @Override
    public Community removeMember(String communityName, String nickname) {
        this.validateCommunityName(communityName);
        this.validateNickname(nickname);
        User user = this.findUser(nickname);
        try {
            Community community = this.communityDao.findCommunityMembers(communityName);
            community.removeMember(user);
            this.communityDao.save(community);
            return community;
        }
        catch (NoResultException ex) {
            throw new IllegalArgumentException("Unknwon community name '" + communityName + "'.");
        }
    }

    private void validateNickname(String managerNickname) {
        if (StringUtils.isBlank((CharSequence)managerNickname)) {
            throw new IllegalArgumentException("Community manager should be defined.");
        }
    }

    private void validateCommunityName(String communityName) {
        if (StringUtils.isBlank((CharSequence)communityName)) {
            throw new IllegalArgumentException("Community name should be defined.");
        }
    }

    private User findUser(String nickname) {
        User user = this.userDao.findByNickname(nickname).orElseThrow(() -> new IllegalArgumentException("Unknown user with nickname '" + nickname + "'."));
        return user;
    }
}

