/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.User;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

@Entity
@Table(name="bo_community")
public class Community
extends AbstractStorageObject {
    private static final long serialVersionUID = -7239278975374588294L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @NotNull
    @Column(name="bo_name")
    private String name;
    @ManyToOne
    @JoinColumn(name="bo_user_ref")
    private User communityManager;
    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(name="bo_community_user", joinColumns={@JoinColumn(name="bo_community_ref")}, inverseJoinColumns={@JoinColumn(name="bo_user_ref")})
    private Set<User> users = new HashSet<User>();

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public User getCommunityManager() {
        return this.communityManager;
    }

    public void setCommunityManager(User user) {
        this.communityManager = user;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public void setUsers(Set<User> users) {
        this.users = users;
    }

    public void addMember(User user) {
        this.users.add(user);
    }

    public void removeMember(User user) {
        this.users.remove(user);
    }

    public String toString() {
        return this.name;
    }
}

