/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResultOfDay;
import de.winkler.betoffice.storage.enums.TotoResult;
import de.winkler.betoffice.storage.exception.StorageObjectNotFoundException;
import de.winkler.betoffice.storage.exception.StorageRuntimeException;
import de.winkler.betoffice.util.LoggerFactory;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

@Entity
@Table(name="bo_gamelist")
public class GameList
extends AbstractStorageObject
implements Comparable<GameList> {
    private static final long serialVersionUID = -3629753274439214154L;
    private static Logger log = LoggerFactory.make();
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Column(name="bo_index")
    private int index;
    @Column(name="bo_openligaid")
    private Long openligaid;
    @Column(name="bo_datetime")
    private ZonedDateTime dateTime;
    @ManyToOne
    @JoinColumn(name="bo_season_ref")
    private Season season;
    @ManyToOne
    @JoinColumn(name="bo_group_ref")
    private Group group;
    @OneToMany(mappedBy="gameList", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @OrderColumn(name="bo_index")
    private List<Game> gameList = new ArrayList<Game>();

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    protected List<Game> getGameList() {
        return this.gameList;
    }

    protected void setGameList(List<Game> value) {
        Validate.notNull(value);
        this.gameList = value;
    }

    public void addGame(Game value) {
        Validate.notNull((Object)value);
        if (this.gameList.contains(value)) {
            log.error("The match '" + value + "' already exists!");
            throw new IllegalArgumentException(value + " already exists!");
        }
        this.gameList.add(value);
        value.setIndex(this.gameList.indexOf(value));
        value.setGameList(this);
    }

    public void removeAllGame() {
        ArrayList<Game> tmp = new ArrayList<Game>(this.getGameList());
        for (Game game : tmp) {
            game.removeAllTipp();
            this.removeGame(game);
        }
    }

    public void removeGame(Game value) {
        Validate.notNull((Object)value);
        if (!this.gameList.contains(value)) {
            throw new IllegalArgumentException(value + " nicht vorhanden!");
        }
        this.gameList.remove(value);
        value.setGameList(null);
    }

    public List<Game> toList(Group _group) {
        return this.toList((Game game) -> game.getGroup().equals(_group));
    }

    public List<Game> toList(Predicate<Game> filter) {
        return this.gameList.stream().filter(filter).collect(Collectors.toList());
    }

    public List<Game> unmodifiableList() {
        return Collections.unmodifiableList(this.gameList);
    }

    public Game get(int _index) {
        return this.gameList.get(_index);
    }

    public Game getById(long id) {
        for (Game game : this.gameList) {
            if (game.getId() != id) continue;
            return game;
        }
        return null;
    }

    public int size() {
        return this.gameList.size();
    }

    public boolean isEmpty() {
        return this.gameList.isEmpty();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int value) {
        this.index = value;
    }

    public ZonedDateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(ZonedDateTime _dateTime) {
        this.dateTime = _dateTime;
    }

    public Season getSeason() {
        return this.season;
    }

    public void setSeason(Season value) {
        this.season = value;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group value) {
        this.group = value;
    }

    public Long getOpenligaid() {
        return this.openligaid;
    }

    public void setOpenligaid(Long value) {
        this.openligaid = value;
    }

    public UserResultOfDay getUserPoints(User user) {
        UserResultOfDay urod = new UserResultOfDay();
        urod.setUser(user);
        for (Game game : this.gameList) {
            if (!game.isPlayed()) continue;
            try {
                GameTipp tipp = game.getGameTipp(user);
                if (urod.getStatus() != null && !tipp.getStatus().equals((Object)urod.getStatus())) {
                    log.error("Der Tipp " + tipp + " ist fehlerhaft!");
                    throw new StorageRuntimeException("Ein Tipp wurde automatisch generiert. Ein anderer Tipp wurde per Teilnehmer generiert. Dieser Zustand sollte nicht auftreten!");
                }
                urod.setStatus(tipp.getStatus());
                urod.setTipps(urod.getTipps() + 1);
                if (tipp.getTotoResult() == TotoResult.EQUAL) {
                    urod.setWin(urod.getWin() + 1);
                    continue;
                }
                if (tipp.getTotoResult() != TotoResult.TOTO) continue;
                urod.setToto(urod.getToto() + 1);
            }
            catch (StorageObjectNotFoundException ex) {
                log.info("Kein Tipp f\u00fcr game: " + game + " vorhanden");
            }
        }
        return urod;
    }

    public List<GameTipp> getTippsOfUser(User user) {
        ArrayList<GameTipp> tippList = new ArrayList<GameTipp>();
        for (Game game : this.gameList) {
            try {
                GameTipp tipp = game.getGameTipp(user);
                tippList.add(tipp);
            }
            catch (StorageObjectNotFoundException ex) {
                log.info(new StringBuffer("F\u00fcr User ").append(user).append(" keinen Tipp gefunden.").toString());
            }
        }
        return tippList;
    }

    public boolean isBefore(GameList _gameList) {
        return this.getIndex() < _gameList.getIndex();
    }

    public boolean isAfter(GameList gd) {
        return this.getIndex() > gd.getIndex();
    }

    public LocalDate findBestRoundDate() {
        ArrayList<ZonedDateTime> matchDates = new ArrayList<ZonedDateTime>();
        for (Game match : this.gameList) {
            matchDates.add(match.getDateTime());
        }
        return GameList.findBestDate(matchDates);
    }

    public static LocalDate findBestDate(List<ZonedDateTime> matchDates) {
        if (matchDates.isEmpty()) {
            return null;
        }
        HashMap<LocalDate, Integer> dates = new HashMap<LocalDate, Integer>();
        for (ZonedDateTime date : matchDates) {
            if (!dates.containsKey(date.toLocalDate())) {
                dates.put(date.toLocalDate(), 0);
            }
            Integer value = (Integer)dates.get(date.toLocalDate());
            dates.put(date.toLocalDate(), value + 1);
        }
        Map.Entry bestDate = null;
        Set values = dates.entrySet();
        for (Map.Entry dateCount : values) {
            if (bestDate == null) {
                bestDate = dateCount;
                continue;
            }
            if ((Integer)dateCount.getValue() <= (Integer)bestDate.getValue()) continue;
            bestDate = dateCount;
        }
        return (LocalDate)bestDate.getKey();
    }

    public boolean isValid() {
        if (this.dateTime == null) {
            return false;
        }
        return this.group != null;
    }

    @Override
    public int compareTo(GameList _round) {
        if (this.getIndex() < _round.getIndex()) {
            return -1;
        }
        if (this.getIndex() > _round.getIndex()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getName() + "# ID: " + this.getId();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GameList)) {
            return false;
        }
        GameList other = (GameList)object;
        return other.getId().equals(this.getId());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getId().hashCode();
        return result;
    }
}

