/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.Validate;

@Entity
@Table(name="bo_group")
public class Group
extends AbstractStorageObject {
    private static final long serialVersionUID = 2621079132943084772L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="bo_season_ref")
    private Season season;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="bo_team_group", joinColumns={@JoinColumn(name="bo_group_ref")}, inverseJoinColumns={@JoinColumn(name="bo_team_ref")})
    private Set<Team> teams = new HashSet<Team>();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="bo_grouptype_ref")
    private GroupType groupType;

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public Season getSeason() {
        return this.season;
    }

    protected void setSeason(Season value) {
        Validate.notNull((Object)value);
        this.season = value;
    }

    public Set<Team> getTeams() {
        return this.teams;
    }

    protected void setTeams(Set<Team> value) {
        this.teams = value;
    }

    public void addTeam(Team value) {
        Validate.notNull((Object)value);
        this.teams.add(value);
    }

    public void removeTeam(Team value) {
        Validate.notNull((Object)value);
        this.teams.remove(value);
    }

    public boolean isGroupMember(Team team) {
        return this.teams.contains(team);
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(GroupType value) {
        this.groupType = value;
    }

    public boolean isValid() {
        if (this.getGroupType() == null) {
            return false;
        }
        return this.getSeason() != null;
    }

    public String toString() {
        return this.getGroupType().getName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Group)) {
            return false;
        }
        Group group = (Group)object;
        return group.getSeason().equals(this.getSeason()) && group.getGroupType().equals(this.getGroupType());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getGroupType().hashCode();
        result = 37 * result + this.getSeason().hashCode();
        return result;
    }
}

