/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.RoundDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.Season;
import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import javax.persistence.NoResultException;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.hibernate.type.ZonedDateTimeType;
import org.springframework.stereotype.Repository;

@Repository(value="roundDao")
public class RoundDaoHibernate
extends AbstractCommonDao<GameList>
implements RoundDao {
    private static final String QUERY_GAMELIST_BY_SEASON = "from GameList as gamelist where gamelist.season.id = :seasonId order by gamelist.index";
    private static final String QUERY_LAST_GAMELIST_BY_SEASON = "from GameList as gamelist where gamelist.season.id = :seasonId and gamelist.index = (  select max(index) from gamelist gl2   where gl2.season.id = :seasonId )";
    private static final String QUERY_FIRST_GAMELIST_BY_SEASON = "from GameList as gamelist where gamelist.season.id = :seasonId and gamelist.index = (  select min(index) from gamelist gl2   where gl2.season.id = :seasonId )";
    private static final String QUERY_GAMELIST_AND_GAMES_BY_SEASON_GROUP = "select distinct round from     GameList as round     left join fetch round.gameList game where     game.group.id = :groupId order    by round.index";
    private static final String QUERY_GAMELIST_OF_GAME = "select round from     GameList as round     join round.gameList game where      game.id = :gameId";
    private static final String QUERY_GAMELIST_BY_SEASON_AND_INDEX = "from GameList as gamelist where gamelist.season.id = :seasonId and gamelist.index = :gameListIndex";
    private static final String QUERY_ALL_ROUND_OBJECTS = "select round from GameList as round left join fetch round.gameList game left join fetch game.tippList tipp left join fetch tipp.user u left join fetch game.homeTeam left join fetch game.guestTeam left join fetch game.group where round.season.id = :seasonId and round.index = :gameListIndex";
    private static final String QUERY_ALL_ROUND_OBJECTS_BY_ID = "select round from GameList as round left join fetch round.gameList game left join fetch game.tippList tipp left join fetch tipp.user u left join fetch game.homeTeam left join fetch game.guestTeam left join fetch game.group where round.id = :roundId";
    private static final String QUERY_NEXT_ROUND_BY_DATE = "select gl.bo_datetime datetime, gl.id last_round_id from bo_gamelist gl where gl.bo_datetime = (   select min(t.bo_datetime) datetime  from  (    select r.bo_datetime, r.id     from bo_gamelist r, bo_game m     where r.bo_season_ref = :season_id       and r.id = m.bo_gamelist_ref       and m.bo_datetime >= :date   ) as t)";
    private static final String QUERY_LAST_ROUND_BY_DATE = "select gl.bo_datetime datetime, gl.id last_round_id from bo_gamelist gl where gl.bo_datetime = (  select max(t.bo_datetime)  from   (    select r.bo_datetime, r.id    from bo_gamelist r, bo_game m    where r.bo_season_ref = :season_id      and r.id = m.bo_gamelist_ref       and m.bo_datetime < :date  ) as t)";
    private static final String QUERY_NEXT_ROUND = AbstractCommonDao.loadQuery("query_next_round.sql");
    private static final String QUERY_PREV_ROUND = AbstractCommonDao.loadQuery("query_prev_round.sql");

    public RoundDaoHibernate() {
        super(GameList.class);
    }

    @Override
    public List<GameList> findRounds(Season season) {
        List objects = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMELIST_BY_SEASON, GameList.class).setParameter("seasonId", (Object)season.getId(), (Type)LongType.INSTANCE).getResultList();
        return objects;
    }

    @Override
    public List<GameList> findRounds(Group group) {
        List objects = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMELIST_AND_GAMES_BY_SEASON_GROUP, GameList.class).setParameter("groupId", (Object)group.getId(), (Type)LongType.INSTANCE).getResultList();
        return objects;
    }

    @Override
    public Optional<GameList> findRound(Season season, int index) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMELIST_BY_SEASON_AND_INDEX, GameList.class).setParameter("seasonId", (Object)season.getId(), (Type)LongType.INSTANCE).setParameter("gameListIndex", (Object)index, (Type)IntegerType.INSTANCE);
        return RoundDaoHibernate.singleResult(query);
    }

    @Override
    public Optional<GameList> findRound(Game game) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMELIST_OF_GAME, GameList.class).setParameter("gameId", (Object)game.getId());
        return RoundDaoHibernate.singleResult(query);
    }

    @Override
    public Optional<GameList> findAllRoundObjects(Season season, int index) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(QUERY_ALL_ROUND_OBJECTS, GameList.class).setParameter("seasonId", (Object)season.getId(), (Type)LongType.INSTANCE).setParameter("gameListIndex", (Object)index, (Type)IntegerType.INSTANCE);
        return RoundDaoHibernate.singleResult(query);
    }

    @Override
    public Optional<GameList> findAllRoundObjects(long roundId) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(QUERY_ALL_ROUND_OBJECTS_BY_ID, GameList.class).setParameter("roundId", (Object)roundId, (Type)LongType.INSTANCE);
        return RoundDaoHibernate.singleResult(query);
    }

    @Override
    public Optional<Long> findNextTippRound(long seasonId, ZonedDateTime date) {
        NativeQuery query = this.getSessionFactory().getCurrentSession().createNativeQuery(QUERY_NEXT_ROUND_BY_DATE);
        query.setParameter("season_id", (Object)seasonId);
        query.setParameter("date", (Object)date, (Type)ZonedDateTimeType.INSTANCE);
        Optional<Long> result = Optional.empty();
        try {
            Object[] object = (Object[])query.getSingleResult();
            BigInteger roundId = (BigInteger)object[1];
            if (roundId != null) {
                result = Optional.of(roundId.longValue());
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Optional<Long> findLastTippRound(long seasonId, ZonedDateTime date) {
        NativeQuery query = this.getSessionFactory().getCurrentSession().createNativeQuery(QUERY_LAST_ROUND_BY_DATE);
        query.setParameter("season_id", (Object)seasonId);
        query.setParameter("date", (Object)date, (Type)ZonedDateTimeType.INSTANCE);
        Optional<Long> result = Optional.empty();
        try {
            Object[] object = (Object[])query.getSingleResult();
            BigInteger roundId = (BigInteger)object[1];
            if (roundId != null) {
                result = Optional.of(roundId.longValue());
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Optional<Long> findNext(long id) {
        NativeQuery query = this.getSessionFactory().getCurrentSession().createNativeQuery(QUERY_NEXT_ROUND);
        query.setParameter("roundId", (Object)id, (Type)LongType.INSTANCE);
        query.addScalar("next_round_id");
        BigInteger uniqueResult = (BigInteger)query.uniqueResult();
        Optional<Long> nextRoundId = Optional.empty();
        if (uniqueResult != null) {
            nextRoundId = Optional.of(uniqueResult.longValue());
        }
        return nextRoundId;
    }

    @Override
    public Optional<Long> findPrevious(long id) {
        NativeQuery query = this.getSessionFactory().getCurrentSession().createNativeQuery(QUERY_PREV_ROUND);
        query.setParameter("roundId", (Object)id, (Type)LongType.INSTANCE);
        query.addScalar("prev_round_id");
        BigInteger uniqueResult = (BigInteger)query.uniqueResult();
        Optional<Long> prevRoundId = Optional.empty();
        if (uniqueResult != null) {
            prevRoundId = Optional.of(uniqueResult.longValue());
        }
        return prevRoundId;
    }

    @Override
    public Optional<GameList> findLastRound(Season season) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(QUERY_LAST_GAMELIST_BY_SEASON, GameList.class).setParameter("seasonId", (Object)season.getId());
        return RoundDaoHibernate.singleResult(query);
    }

    @Override
    public Optional<GameList> findFirstRound(Season season) {
        Query query = this.getSessionFactory().getCurrentSession().createQuery(QUERY_FIRST_GAMELIST_BY_SEASON, GameList.class).setParameter("seasonId", (Object)season.getId());
        return RoundDaoHibernate.singleResult(query);
    }
}

