/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.UserSeason;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="bo_user")
public class User
extends AbstractStorageObject {
    private static final long serialVersionUID = -1806113679051281041L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Column(name="bo_name")
    private String name;
    @Column(name="bo_surname")
    private String surname;
    @Column(name="bo_nickname")
    private String nickName;
    @Column(name="bo_email")
    private String email;
    @Column(name="bo_phone")
    private String phone;
    @Column(name="bo_password")
    private String password;
    @Column(name="bo_automat")
    private boolean automat = false;
    @Column(name="bo_excluded")
    private boolean exclude = false;
    @Column(name="bo_admin")
    private boolean admin = false;
    @Column(name="bo_title")
    private String title;
    @OneToMany
    @JoinColumn(name="bo_user_ref")
    private Set<UserSeason> userSeason = new HashSet<UserSeason>();

    public User() {
    }

    public User(String _nickname) {
        this.setNickName(_nickname);
    }

    public User(String aName, String aSurname, String aNickname, String aMail, String aPhone, String aPwd, String aTitle, boolean aIsAuto, boolean aIsExcluded) {
        this.setName(aName);
        this.setSurname(aSurname);
        this.setNickName(aNickname);
        this.setEmail(aMail);
        this.setPhone(aPhone);
        this.setPassword(aPwd);
        this.setTitle(aTitle);
        this.setAutomat(aIsAuto);
        this.setExcluded(aIsExcluded);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String value) {
        this.surname = value;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String value) {
        this.nickName = value;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String value) {
        this.email = value;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String value) {
        this.phone = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public boolean isAutomat() {
        return this.automat;
    }

    public void setAutomat(boolean value) {
        this.automat = value;
    }

    public boolean isExcluded() {
        return this.exclude;
    }

    public void setExcluded(boolean value) {
        this.exclude = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean _admin) {
        this.admin = _admin;
    }

    public Set<UserSeason> getUserSeason() {
        return this.userSeason;
    }

    protected void setUserSeason(Set<UserSeason> value) {
        this.userSeason = value;
    }

    public boolean comparePwd(String value) {
        return StringUtils.equals((CharSequence)value, (CharSequence)this.password);
    }

    public String getDebugInfo() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name);
        buf.append(": ");
        buf.append(this.surname);
        buf.append(": ");
        buf.append(this.nickName);
        buf.append(": ");
        buf.append(this.email);
        buf.append(": ");
        buf.append(this.phone);
        buf.append(": ");
        buf.append(this.password);
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.nickName);
        return buf.toString();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return user.getNickName().equalsIgnoreCase(this.getNickName());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getNickName().hashCode();
        return result;
    }
}

