/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.dao.hibernate;

import de.winkler.betoffice.dao.GameTippDao;
import de.winkler.betoffice.dao.hibernate.AbstractCommonDao;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.User;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Repository;

@Repository(value="gameTippDao")
public class GameTippDaoHibernate
extends AbstractCommonDao<GameTipp>
implements GameTippDao {
    private static final String QUERY_GAMETIPP_BY_MATCH = "from     GameTipp gametipp    inner join fetch gametipp.user     inner join fetch gametipp.game where     gametipp.game.id = :gameId";
    private static final String QUERY_GAMETIPP_BY_MATCH_AND_USER = "from     GameTipp gametipp    inner join fetch gametipp.user     inner join fetch gametipp.game where     gametipp.game.id = :gameId     and gametipp.user.id = :userId";
    private static final String QUERY_ROUND_GAME_TIPP_AND_USER = AbstractCommonDao.loadQuery("hql_round_game_tipp_user.sql");

    public GameTippDaoHibernate() {
        super(GameTipp.class);
    }

    @Override
    public List<GameTipp> find(Game match) {
        List tipps = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMETIPP_BY_MATCH, GameTipp.class).setParameter("gameId", (Object)match.getId()).getResultList();
        return tipps;
    }

    @Override
    public Optional<GameTipp> find(Game game, User user) {
        Optional tipp = this.getSessionFactory().getCurrentSession().createQuery(QUERY_GAMETIPP_BY_MATCH_AND_USER, GameTipp.class).setParameter("gameId", (Object)game.getId()).setParameter("userId", (Object)user.getId()).uniqueResultOptional();
        return tipp;
    }

    @Override
    public List<GameTipp> find(long roundId, long userId) {
        List tipps = this.getSessionFactory().getCurrentSession().createQuery(QUERY_ROUND_GAME_TIPP_AND_USER, GameTipp.class).setParameter("roundId", (Object)roundId).setParameter("userId", (Object)userId).getResultList();
        return tipps;
    }
}

