/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.service;

import de.winkler.betoffice.dao.GameTippDao;
import de.winkler.betoffice.dao.GoalDao;
import de.winkler.betoffice.dao.GroupDao;
import de.winkler.betoffice.dao.GroupTypeDao;
import de.winkler.betoffice.dao.MatchDao;
import de.winkler.betoffice.dao.PlayerDao;
import de.winkler.betoffice.dao.RoundDao;
import de.winkler.betoffice.dao.SeasonDao;
import de.winkler.betoffice.dao.TeamDao;
import de.winkler.betoffice.dao.UserDao;
import de.winkler.betoffice.dao.UserSeasonDao;
import de.winkler.betoffice.service.AbstractManagerService;
import de.winkler.betoffice.service.SeasonManagerService;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.Goal;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Player;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.TeamResult;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResult;
import de.winkler.betoffice.storage.UserSeason;
import de.winkler.betoffice.storage.enums.RoleType;
import de.winkler.betoffice.validation.BetofficeValidationException;
import de.winkler.betoffice.validation.BetofficeValidationMessage;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="seasonManagerService")
public class DefaultSeasonManagerService
extends AbstractManagerService
implements SeasonManagerService {
    @Autowired
    private UserSeasonDao userSeasonDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private SeasonDao seasonDao;
    @Autowired
    private TeamDao teamDao;
    @Autowired
    private GroupDao groupDao;
    @Autowired
    private GroupTypeDao groupTypeDao;
    @Autowired
    private RoundDao roundDao;
    @Autowired
    private MatchDao matchDao;
    @Autowired
    private GameTippDao gameTippDao;
    @Autowired
    private PlayerDao playerDao;
    @Autowired
    private GoalDao goalDao;

    @Override
    @Transactional(readOnly=true)
    public List<UserResult> calculateUserRanking(GameList round) {
        List<User> users = this.userSeasonDao.findUsers(round.getSeason());
        return this.userDao.calculateUserRanking(users, round);
    }

    @Override
    @Transactional(readOnly=true)
    public List<UserResult> calculateUserRanking(Season season, int startIndex, int endIndex) {
        List<User> users = this.userSeasonDao.findUsers(season);
        return this.userDao.calculateUserRanking(users, season, startIndex, endIndex);
    }

    @Override
    @Transactional(readOnly=true)
    public List<UserResult> calculateUserRanking(Season season) {
        List<User> users = this.userSeasonDao.findUsers(season);
        return this.userDao.calculateUserRanking(users, season);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeamResult> calculateTeamRanking(Season season, GroupType groupType) {
        return this.seasonDao.calculateTeamRanking(season, groupType);
    }

    @Override
    @Transactional(readOnly=true)
    public List<TeamResult> calculateTeamRanking(Season season, GroupType groupType, int startIndex, int endIndex) {
        return this.seasonDao.calculateTeamRanking(season, groupType, startIndex, endIndex);
    }

    @Override
    @Transactional(readOnly=true)
    public List<User> findActivatedUsers(Season season) {
        return this.userSeasonDao.findUsers(season);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Season> findAllSeasons() {
        return this.seasonDao.findAll();
    }

    @Override
    @Transactional(readOnly=true)
    public List<Team> findTeams(Group group) {
        return this.groupDao.findTeams(group);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Team> findTeams(Season season, GroupType groupType) {
        return this.teamDao.findTeamsBySeasonAndGroup(season, groupType);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GroupType> findGroupTypesBySeason(Season season) {
        return this.groupTypeDao.findBySeason(season);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Game> findMatches(Team homeTeam, Team guestTeam) {
        return this.matchDao.find(homeTeam, guestTeam);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Game> findMatches(GameList round) {
        return this.matchDao.find(round);
    }

    @Override
    @Transactional(readOnly=true)
    public Game findMatch(Long gameId) {
        return (Game)this.matchDao.findById(gameId);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Game> findMatch(GameList round, Team homeTeam, Team guestTeam) {
        return this.matchDao.find(round, homeTeam, guestTeam);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Game> findMatches(Team homeTeam, Team guestTeam, boolean spin) {
        ArrayList<Game> results = new ArrayList<Game>();
        if (spin) {
            results.addAll(this.matchDao.findAll(homeTeam, guestTeam));
        } else {
            results.addAll(this.matchDao.find(homeTeam, guestTeam));
        }
        return results;
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<GameList> findRound(Season season, int index) {
        return this.roundDao.findRound(season, index);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<GameList> findLastRound(Season season) {
        return this.roundDao.findLastRound(season);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<GameList> findFirstRound(Season season) {
        return this.roundDao.findFirstRound(season);
    }

    @Override
    @Transactional(readOnly=true)
    public GameList findRound(long id) {
        return (GameList)this.roundDao.findById(id);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<GameList> findRoundGameAndTipp(long roundId) {
        return this.roundDao.findRound(roundId);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<GameList> findNextRound(long id) {
        Optional<Long> nextRoundId = this.roundDao.findNext(id);
        Optional<GameList> nextGameList = Optional.empty();
        if (nextRoundId.isPresent()) {
            nextGameList = Optional.of((GameList)this.roundDao.findById(nextRoundId.get()));
        }
        return nextGameList;
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<GameList> findPrevRound(long id) {
        Optional<Long> prevRoundId = this.roundDao.findPrevious(id);
        Optional<GameList> prevGameList = Optional.empty();
        if (prevRoundId.isPresent()) {
            prevGameList = Optional.of((GameList)this.roundDao.findById(prevRoundId.get()));
        }
        return prevGameList;
    }

    @Override
    @Transactional(readOnly=true)
    public List<GameList> findRounds(Season season) {
        return this.roundDao.findRounds(season);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GameList> findRounds(Group group) {
        return this.roundDao.findRounds(group);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Group> findGroups(Season season) {
        return this.groupDao.findBySeason(season);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GroupType> findGroupTypes(Season season) {
        return this.groupTypeDao.findBySeason(season);
    }

    @Override
    @Transactional(readOnly=true)
    public Group findGroup(Season season, GroupType groupType) {
        return this.groupDao.findBySeasonAndGroupType(season, groupType);
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Season> findSeasonByName(String name, String year) {
        return this.seasonDao.findByName(name, year);
    }

    @Override
    @Transactional(readOnly=true)
    public Season findSeasonById(long id) {
        return (Season)this.seasonDao.findById(id);
    }

    @Override
    @Transactional
    public Game addMatch(GameList round, ZonedDateTime date, Group group, Team homeTeam, Team guestTeam) {
        GameList gamelist = (GameList)this.roundDao.findById(round.getId());
        Game match = new Game();
        match.setDateTime(date);
        match.setHomeTeam(homeTeam);
        match.setGuestTeam(guestTeam);
        match.setGroup(group);
        this.matchDao.save(match);
        gamelist.addGame(match);
        this.roundDao.update(gamelist);
        return match;
    }

    @Override
    @Transactional
    public Game addMatch(GameList round, ZonedDateTime date, Group group, Team homeTeam, Team guestTeam, int homeGoals, int guestGoals) {
        return this.addMatch(round, date, group, homeTeam, guestTeam, GameResult.of(homeGoals, guestGoals));
    }

    @Override
    @Transactional
    public Game addMatch(GameList round, ZonedDateTime date, Group group, Team homeTeam, Team guestTeam, GameResult result) {
        GameList gamelist = (GameList)this.roundDao.findById(round.getId());
        Game match = new Game();
        match.setDateTime(date);
        match.setHomeTeam(homeTeam);
        match.setGuestTeam(guestTeam);
        match.setGroup(group);
        match.setResult(result);
        match.setPlayed(true);
        this.matchDao.save(match);
        gamelist.addGame(match);
        this.roundDao.update(gamelist);
        return match;
    }

    @Override
    @Transactional
    public Game addMatch(Season season, int round, ZonedDateTime date, GroupType groupType, Team homeTeam, Team guestTeam) {
        Season persistedSeason = (Season)this.seasonDao.findById(season.getId());
        return this.addMatch(persistedSeason.getGamesOfDay(round), date, persistedSeason.getGroup(groupType), homeTeam, guestTeam);
    }

    @Override
    @Transactional
    public Game addMatch(Season season, int round, ZonedDateTime date, GroupType groupType, Team homeTeam, Team guestTeam, int homeGoals, int guestGoals) {
        Season persistedSeason = (Season)this.seasonDao.findById(season.getId());
        return this.addMatch(persistedSeason.getGamesOfDay(round), date, persistedSeason.getGroup(groupType), homeTeam, guestTeam, homeGoals, guestGoals);
    }

    @Override
    @Transactional
    public GameList addRound(Season season, ZonedDateTime date, GroupType groupType) {
        GameList round = new GameList();
        round.setDateTime(date);
        Group group = this.groupDao.findBySeasonAndGroupType(season, groupType);
        round.setGroup(group);
        Season persistedSeason = (Season)this.seasonDao.findById(season.getId());
        persistedSeason.addGameList(round);
        this.roundDao.save(round);
        return round;
    }

    @Override
    @Transactional
    public Group addTeam(Season season, GroupType groupType, Team team) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (!season.getTeamType().equals((Object)team.getTeamType())) {
            messages.add(new BetofficeValidationMessage("Der Meisterschaft unterst\u00fctzt diesen Mannschaftstyp nicht.", null, BetofficeValidationMessage.Severity.ERROR));
        }
        if (messages.size() == 0) {
            Group group = this.groupDao.findBySeasonAndGroupType(season, groupType);
            group.addTeam(team);
            this.groupDao.update(group);
            return group;
        }
        throw new BetofficeValidationException(messages);
    }

    @Override
    @Transactional
    public Group addTeams(Season season, GroupType groupType, Collection<Team> teams) {
        teams.stream().forEach(team -> this.addTeam(season, groupType, (Team)team));
        return this.groupDao.findBySeasonAndGroupType(season, groupType);
    }

    @Override
    @Transactional
    public void addUser(Season season, User user) {
        this.addUsers(season, List.of(user));
    }

    @Override
    @Transactional
    public void addUsers(Season season, Collection<User> users) {
        Season season2 = (Season)this.seasonDao.findById(season.getId());
        List<User> activeUsers = this.findActivatedUsers(season);
        users.stream().filter(user -> !activeUsers.contains(user)).forEach(user -> {
            UserSeason userSeason = new UserSeason();
            userSeason.setUser((User)user);
            userSeason.setRoleType(RoleType.TIPPER);
            season2.addUser(userSeason);
            this.userSeasonDao.save(userSeason);
        });
    }

    @Override
    @Transactional
    public Season createSeason(Season season) {
        try {
            this.seasonDao.save(season);
            return season;
        }
        catch (ConstraintViolationException ex) {
            ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
            messages.add(new BetofficeValidationMessage("Diese Meisterschaft ist bereits vorhanden.", null, BetofficeValidationMessage.Severity.ERROR));
            throw new BetofficeValidationException(messages);
        }
    }

    @Override
    @Transactional
    public void deleteSeason(Season season) {
        ArrayList<BetofficeValidationMessage> messages = new ArrayList<BetofficeValidationMessage>();
        if (this.findActivatedUsers(season).size() > 0) {
            messages.add(new BetofficeValidationMessage("Der Meisterschaft sind Teilnehmer zugeordnet.", null, BetofficeValidationMessage.Severity.ERROR));
        }
        if (this.findRounds(season).size() > 0) {
            messages.add(new BetofficeValidationMessage("Der Meisterschaft sind Spieltage zugeordnet.", null, BetofficeValidationMessage.Severity.ERROR));
        }
        if (this.findGroups(season).size() > 0) {
            messages.add(new BetofficeValidationMessage("Der Meisterschaft sind Gruppen zugordnet.", null, BetofficeValidationMessage.Severity.ERROR));
        }
        if (messages.size() != 0) {
            throw new BetofficeValidationException(messages);
        }
        this.seasonDao.delete(season);
    }

    @Override
    @Transactional
    public void removeMatch(Game match) {
        match.getGameList().removeGame(match);
        this.matchDao.delete(match);
    }

    @Override
    @Transactional
    public void removeRound(Season season, GameList round) {
        season.removeGameList(round);
        this.roundDao.delete(round);
    }

    @Override
    @Transactional
    public void removeTeam(Season season, GroupType groupType, Team team) {
        Group group = this.groupDao.findBySeasonAndGroupType(season, groupType);
        group.removeTeam(team);
        this.groupDao.update(group);
    }

    @Override
    @Transactional
    public void removeTeams(Season season, GroupType groupType, Collection<Team> teams) {
        teams.stream().forEach(team -> this.removeTeam(season, groupType, (Team)team));
    }

    @Override
    @Transactional
    public void removeUsers(Season season, Collection<User> users) {
        List<User> activeUsers = this.findActivatedUsers(season);
        Season season2 = (Season)this.seasonDao.findById(season.getId());
        users.stream().filter(user -> activeUsers.contains(user)).forEach(user -> {
            UserSeason userSeason = season2.removeUser((User)user);
            this.userSeasonDao.delete(userSeason);
        });
    }

    @Override
    @Transactional
    public void updateMatch(Game match) {
        this.matchDao.update(match);
    }

    @Override
    @Transactional
    public void updateMatch(Collection<Game> modifiedMatches) {
        for (Game match : modifiedMatches) {
            this.matchDao.update(match);
        }
    }

    @Override
    @Transactional
    public void updateSeason(Season season) {
        this.seasonDao.update(season);
    }

    @Override
    @Transactional
    public Season addGroupType(Season season, GroupType groupType) {
        if (season == null) {
            throw new IllegalArgumentException("Parameter season is null!");
        }
        if (groupType == null) {
            throw new IllegalArgumentException("Parameter groupType is null!");
        }
        Season persistedSeason = (Season)this.seasonDao.findById(season.getId());
        Group group = new Group();
        group.setGroupType(groupType);
        persistedSeason.addGroup(group);
        this.groupDao.save(group);
        return persistedSeason;
    }

    @Override
    @Transactional
    public void addGroupType(Season season, Collection<GroupType> groupTypes) {
        for (GroupType groupType : groupTypes) {
            this.addGroupType(season, groupType);
        }
    }

    @Override
    @Transactional
    public void removeGroupType(Season season, GroupType groupType) {
        if (season.getGroup(groupType) != null) {
            Group group = season.removeGroup(groupType);
            this.groupDao.delete(group);
        }
    }

    @Override
    @Transactional
    public void removeGroupType(Season season, Collection<GroupType> groupTypes) {
        for (GroupType groupType : groupTypes) {
            this.removeGroupType(season, groupType);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<GameTipp> findTipps(GameList round, User user) {
        return this.gameTippDao.find(round, user);
    }

    @Override
    @Transactional(readOnly=true)
    public List<GameTipp> findTippsByMatch(Game match) {
        return this.gameTippDao.find(match);
    }

    @Override
    @Transactional(readOnly=false)
    public Optional<Player> findGoalsOfPlayer(long id) {
        return this.playerDao.findAllGoalsOfPlayer(id);
    }

    @Override
    @Transactional
    public void addGoal(Game match, Goal goal) {
        match.addGoal(goal);
        goal.setGame(match);
        this.matchDao.save(match);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Goal> findAllGoals() {
        return this.goalDao.findAll();
    }
}

