/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.storage;

import de.winkler.betoffice.storage.AbstractStorageObject;
import de.winkler.betoffice.storage.ChampionshipConfiguration;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.Group;
import de.winkler.betoffice.storage.GroupType;
import de.winkler.betoffice.storage.Team;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserSeason;
import de.winkler.betoffice.storage.enums.SeasonType;
import de.winkler.betoffice.storage.enums.TeamType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateTime;

@Entity
@Table(name="bo_season")
public class Season
extends AbstractStorageObject {
    private static final long serialVersionUID = -8992251563826611291L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Embedded
    private ChampionshipConfiguration championshipConfiguration = new ChampionshipConfiguration();
    @Enumerated
    @Column(name="bo_mode")
    private SeasonType mode = SeasonType.LEAGUE;
    @Enumerated
    @Column(name="bo_teamtype")
    private TeamType teamType = TeamType.DFB;
    @NotNull
    @Column(name="bo_year")
    private String year;
    @NotNull
    @Column(name="bo_name")
    private String name;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="bo_season_ref")
    private Set<Group> groups = new HashSet<Group>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="bo_season_ref")
    private Set<UserSeason> userSeason = new HashSet<UserSeason>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="bo_season_ref")
    @OrderColumn(name="bo_index")
    private List<GameList> gameList = new ArrayList<GameList>();

    @Override
    public Long getId() {
        return this.id;
    }

    protected void setId(Long value) {
        this.id = value;
    }

    public ChampionshipConfiguration getChampionshipConfiguration() {
        return this.championshipConfiguration;
    }

    protected void setChampionshipConfiguration(ChampionshipConfiguration value) {
        this.championshipConfiguration = value;
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String value) {
        this.year = value.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value.trim();
    }

    public SeasonType getMode() {
        return this.mode;
    }

    public void setMode(SeasonType value) {
        this.mode = value;
    }

    public TeamType getTeamType() {
        return this.teamType;
    }

    public void setTeamType(TeamType value) {
        this.teamType = value;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    protected void setGroups(Set<Group> value) {
        this.groups = value;
    }

    public Group getGroup(GroupType groupType) {
        for (Group group : this.getGroups()) {
            if (!group.getGroupType().equals(groupType)) continue;
            return group;
        }
        return null;
    }

    public void addGroup(Group group) {
        Validate.notNull((Object)group);
        group.setSeason(this);
        this.groups.add(group);
    }

    public void addGroups(Set<Group> values) {
        Validate.notNull(values);
        for (Group group : values) {
            this.addGroup(group);
        }
    }

    public Group isActivated(GroupType _groupType) {
        for (Group group : this.getGroups()) {
            if (!group.getGroupType().equals(_groupType)) continue;
            return group;
        }
        return null;
    }

    public void removeGroup(Group group) {
        Validate.notNull((Object)group.getSeason());
        Validate.isTrue((boolean)group.getSeason().equals(this));
        this.groups.remove(group);
    }

    public Group removeGroup(GroupType groupType) {
        Iterator<Group> i = this.getGroups().iterator();
        while (i.hasNext()) {
            Group tmp = i.next();
            if (!tmp.getGroupType().equals(groupType)) continue;
            i.remove();
            return tmp;
        }
        return null;
    }

    public Set<Team> getTeams() {
        HashSet<Team> teams = new HashSet<Team>();
        for (Group group : this.getGroups()) {
            teams.addAll(group.getTeams());
        }
        return teams;
    }

    public List<GroupType> getGroupTypes() {
        ArrayList<GroupType> result = new ArrayList<GroupType>();
        for (Group group : this.getGroups()) {
            result.add(group.getGroupType());
        }
        return result;
    }

    public Set<UserSeason> getUserSeason() {
        return this.userSeason;
    }

    protected void setUserSeason(Set<UserSeason> value) {
        this.userSeason = value;
    }

    public void addUser(UserSeason user) {
        Validate.notNull((Object)user.getUser());
        if (user.getSeason() != null) {
            user.getSeason().removeUser(user);
        }
        user.setSeason(this);
        this.userSeason.add(user);
    }

    public void removeUser(UserSeason user) {
        Validate.notNull((Object)user.getUser());
        Validate.isTrue((boolean)user.getSeason().equals(this));
        this.userSeason.remove(user);
    }

    public UserSeason removeUser(User user) {
        Iterator<UserSeason> i = this.getUserSeason().iterator();
        while (i.hasNext()) {
            UserSeason tmp = i.next();
            if (!tmp.getUser().equals(user)) continue;
            i.remove();
            return tmp;
        }
        return null;
    }

    public List<User> getUsers() {
        ArrayList<User> users = new ArrayList<User>();
        for (UserSeason tmp : this.getUserSeason()) {
            users.add(tmp.getUser());
        }
        return users;
    }

    protected List<GameList> getGameList() {
        return this.gameList;
    }

    protected void setGameList(List<GameList> value) {
        Validate.notNull(value);
        this.gameList = value;
    }

    public List<GameList> toGameList() {
        return Collections.unmodifiableList(this.gameList);
    }

    public List<GameList> toGameList(Predicate<GameList> filter) {
        return this.gameList.stream().filter(filter).collect(Collectors.toList());
    }

    public int size() {
        return this.gameList.size();
    }

    public int indexOf(Object object) {
        return this.gameList.indexOf(object);
    }

    public boolean contains(GameList _gameList) {
        return this.gameList.contains(_gameList);
    }

    public GameList getGamesOfDay(int dayNr) {
        if (dayNr >= this.gameList.size() || dayNr < 0) {
            throw new IndexOutOfBoundsException("dayNr '" + dayNr + "' out of bounds!");
        }
        if (this.gameList.size() == 0) {
            return null;
        }
        for (GameList currGameList : this.gameList) {
            if (currGameList.getIndex() == -1) {
                String dateTime = new DateTime((Object)currGameList.getDateTime()).toString("dd.MM.yyyy HH:mm", Locale.GERMANY);
                throw new IllegalStateException("current round index: " + currGameList.getIndex() + "; dateTime: " + dateTime);
            }
            if (currGameList.getIndex() != dayNr) continue;
            return currGameList;
        }
        throw new IllegalStateException();
    }

    public void addGameList(GameList newRound) {
        Validate.notNull((Object)newRound, (String)"The newRound parameter is null.", (Object[])new Object[0]);
        Validate.notNull((Object)newRound.getDateTime(), (String)"The datetime field of newRound is null.", (Object[])new Object[0]);
        Validate.notNull((Object)newRound.getGroup(), (String)"The group field of newRound is null.", (Object[])new Object[0]);
        for (GameList gl : this.getGameList()) {
            if (gl.getDateTime() == null || !gl.getDateTime().equals(newRound.getDateTime()) || !gl.getGroup().equals(newRound.getGroup())) continue;
            String error = String.format("Round [%s] with same date and group is already there.", newRound.toString());
            throw new IllegalArgumentException(error);
        }
        newRound.setSeason(this);
        newRound.setIndex(this.gameList.size());
        this.gameList.add(newRound);
    }

    public void removeAllGameList() {
        ArrayList<GameList> tmp = new ArrayList<GameList>(this.getGameList());
        for (GameList gl : tmp) {
            gl.removeAllGame();
            this.removeGameList(gl);
        }
    }

    public void removeGameList(GameList _gameList) {
        Validate.notNull((Object)_gameList);
        if (!this.gameList.contains(_gameList)) {
            StringBuilder buf = new StringBuilder(_gameList.toString());
            buf.append(" nicht vorhanden!");
            throw new IllegalArgumentException(buf.toString());
        }
        this.gameList.remove(_gameList);
        _gameList.setSeason(null);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Year: ").append(this.getYear());
        buf.append(", Name: ").append(this.getName());
        if (this.getMode() == null) {
            buf.append(", Mode:").append("<null>");
        } else {
            buf.append(", Mode:").append(this.getMode().toString());
        }
        return buf.toString();
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Season)) {
            return false;
        }
        return this.getYear().equals(((Season)object).getYear()) && this.getName().equals(((Season)object).getName()) && this.getMode().equals((Object)((Season)object).getMode());
    }

    public final int hashCode() {
        int result = 17;
        result = 37 * result + this.getName().hashCode();
        result = 37 * result + this.getYear().hashCode();
        result = 37 * result + this.getMode().hashCode();
        return result;
    }
}

