/*
 * Decompiled with CFR 0.152.
 */
package de.winkler.betoffice.tippengine;

import de.winkler.betoffice.service.SeasonManagerService;
import de.winkler.betoffice.service.TippService;
import de.winkler.betoffice.storage.Game;
import de.winkler.betoffice.storage.GameList;
import de.winkler.betoffice.storage.GameResult;
import de.winkler.betoffice.storage.GameTipp;
import de.winkler.betoffice.storage.Season;
import de.winkler.betoffice.storage.User;
import de.winkler.betoffice.storage.UserResultOfDay;
import de.winkler.betoffice.storage.enums.TippStatusType;
import de.winkler.betoffice.tippengine.InfoCenter;
import de.winkler.betoffice.util.LoggerFactory;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MinTippGenerator {
    private static final String BOT_MIN_TIPP = "#BOT_MIN_TIPP#";
    private final Logger log = LoggerFactory.make();
    @Autowired
    private InfoCenter infoCenter;
    @Autowired
    private TippService tippService;
    @Autowired
    private SeasonManagerService seasonManagerService;

    @Transactional
    public void generateTipp(Season season, User user) {
        List<GameList> rounds = this.seasonManagerService.findRounds(season);
        for (GameList round : rounds) {
            this.generateTipp(round, user);
        }
    }

    @Transactional
    public void generateTipp(GameList round, User user) {
        List<User> users = this.seasonManagerService.findActivatedUsers(round.getSeason());
        if (!user.isExcluded() && !user.isAutomat()) {
            this.createOrUpdateMinimumTipp(round, user, users);
        }
    }

    private void createOrUpdateMinimumTipp(GameList round, User user, List<User> activeUsers) {
        UserResultOfDay worstUser = this.infoCenter.findWorstTipp(round, activeUsers);
        this.log.debug("Min-Tipp von User: {}", (Object)worstUser);
        List<Game> games = this.seasonManagerService.findMatches(round);
        for (Game game : games) {
            Optional<GameTipp> tipp;
            Optional<GameTipp> minTipp;
            this.log.info("Generiere Tipp f\u00fcr User: {} fuer das Spiel {}", (Object)user, (Object)game);
            GameResult minTippResult = null;
            minTippResult = worstUser == null ? GameResult.of(0, 0) : ((minTipp = this.tippService.findTipp(game, worstUser.getUser())).isPresent() ? minTipp.get().getTipp() : GameResult.of(0, 0));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ermittelter Min-Tipp: {}", (Object)minTippResult);
            }
            if ((tipp = this.tippService.findTipp(game, user)).isPresent()) {
                GameTipp presentTipp = tipp.get();
                if (presentTipp.getStatus() == TippStatusType.MIN || presentTipp.getStatus() == TippStatusType.UNDEFINED || presentTipp.getStatus() == TippStatusType.INVALID) {
                    this.tippService.createOrUpdateTipp(BOT_MIN_TIPP, game, user, minTippResult, TippStatusType.MIN);
                } else if (presentTipp.getStatus() == TippStatusType.AUTO || presentTipp.getStatus() == TippStatusType.USER) {
                    this.log.debug("Tipp wird nicht \u00fcberschrieben.");
                }
            } else {
                this.tippService.createOrUpdateTipp(BOT_MIN_TIPP, game, user, minTippResult, TippStatusType.MIN);
            }
            this.log.debug("User: {} Min-Tipp: {}", (Object)user, (Object)minTippResult);
        }
    }
}

